/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.example;

import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import uk.org.ogsadai.client.toolkit.DataRequestExecutionResource;
import uk.org.ogsadai.client.toolkit.RequestExecutionType;
import uk.org.ogsadai.client.toolkit.ServerProxy;
import uk.org.ogsadai.client.toolkit.Workflow;
import uk.org.ogsadai.client.toolkit.document.DocumentWorkflow;
import uk.org.ogsadai.client.toolkit.example.ClientBase;
import uk.org.ogsadai.client.toolkit.exception.RequestExecutionException;
import uk.org.ogsadai.data.CharData;
import uk.org.ogsadai.data.StringData;
import uk.org.ogsadai.resource.ResourceID;

public class DocumentClient
extends ClientBase {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    private static final String REQUEST_FILE = "r";
    private static final String DISPLAY_REQUEST_STATUS = "displayRequestStatus";
    private static final String SYNCHRONOUS = "sync";
    private static final String DISPLAY_OUTPUT = "o";
    private static final String URL = "u";
    private static final String DRER = "e";
    private static final String REQUEST_SCHEMA = "s";

    public static void main(String[] stringArray) throws Exception {
        DocumentClient documentClient = new DocumentClient();
        documentClient.execute(stringArray);
    }

    public void execute(String[] stringArray) throws Exception {
        List list;
        String string;
        Hashtable hashtable = new Hashtable();
        super.parseArguments(stringArray, hashtable);
        String string2 = super.getSingleValueOptionalFlag(hashtable, URL);
        if (string2 == null) {
            string2 = "http://localhost:8080/dai/services/";
        }
        if ((string = super.getSingleValueOptionalFlag(hashtable, DRER)) == null) {
            string = "DataRequestExecutionResource";
        }
        ResourceID resourceID = new ResourceID(string);
        ServerProxy serverProxy = new ServerProxy();
        serverProxy.setDefaultBaseServicesURL(new URL(string2));
        String string3 = super.getSingleValueOptionalFlag(hashtable, REQUEST_SCHEMA);
        if (string3 == null) {
            string3 = string2 + "../schema/ogsadai/types/Request.xsd";
        }
        DataRequestExecutionResource dataRequestExecutionResource = serverProxy.getDataRequestExecutionResource(resourceID);
        String string4 = super.getSingleValue(hashtable, REQUEST_FILE);
        boolean bl = Boolean.valueOf(super.getSingleValueOptionalFlag(hashtable, DISPLAY_REQUEST_STATUS));
        boolean bl2 = Boolean.valueOf(super.getSingleValueOptionalFlag(hashtable, SYNCHRONOUS));
        RequestExecutionType requestExecutionType = RequestExecutionType.SYNCHRONOUS;
        if (bl2) {
            requestExecutionType = RequestExecutionType.ASYNCHRONOUS;
        }
        if ((list = super.getValuesOptionalFlag(hashtable, DISPLAY_OUTPUT)) == null) {
            list = Collections.EMPTY_LIST;
        }
        DocumentClient.executeRequest(dataRequestExecutionResource, string4, new URL(string3), bl, list, requestExecutionType);
    }

    private static void executeRequest(DataRequestExecutionResource dataRequestExecutionResource, String string, URL uRL, boolean bl, List list, RequestExecutionType requestExecutionType) throws Exception {
        Object object;
        DocumentWorkflow documentWorkflow = new DocumentWorkflow(string, uRL);
        try {
            object = dataRequestExecutionResource.execute((Workflow)documentWorkflow, requestExecutionType);
            if (bl) {
                System.out.println("Request Status:");
                System.out.println("======================================================================");
                System.out.print(object.getRequestStatus());
                System.out.println("======================================================================");
                System.out.println();
            }
        }
        catch (RequestExecutionException requestExecutionException) {
            System.out.println(requestExecutionException.getRequestResource().getRequestStatus());
            throw requestExecutionException;
        }
        object = list.iterator();
        System.out.println("Results:");
        while (object.hasNext()) {
            String string2 = (String)object.next();
            Map map = documentWorkflow.getResults(string2);
            for (String string3 : map.keySet()) {
                System.out.println("======================================================================");
                System.out.println("Activity Results: instance=\"" + string2 + "\", result=\"" + string3 + "\"");
                System.out.println("============================DATA BEGIN================================");
                List list2 = (List)map.get(string3);
                for (Object e : list2) {
                    if (e instanceof StringData || e instanceof CharData) {
                        System.out.print(e);
                        continue;
                    }
                    System.out.println(e);
                }
                System.out.println("============================DATA END==================================");
                System.out.println();
            }
        }
    }
}

