/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.example;

import java.net.URL;
import java.util.Hashtable;
import uk.org.ogsadai.client.toolkit.DataSourceResource;
import uk.org.ogsadai.client.toolkit.DataStreamData;
import uk.org.ogsadai.client.toolkit.DataStreamStatus;
import uk.org.ogsadai.client.toolkit.ServerProxy;
import uk.org.ogsadai.client.toolkit.example.ClientBase;
import uk.org.ogsadai.data.CharData;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.StringData;
import uk.org.ogsadai.resource.ResourceID;

public class DataSourceClient
extends ClientBase {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    private static final String URL = "u";
    private static final String DATASOURCE = "d";
    private static final String NUM_BLOCKS = "n";
    private static final String DESTROY = "destroy";

    public static void main(String[] stringArray) throws Exception {
        DataSourceClient dataSourceClient = new DataSourceClient();
        dataSourceClient.execute(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String[] stringArray) throws Exception {
        int n;
        Hashtable hashtable = new Hashtable();
        super.parseArguments(stringArray, hashtable);
        String string = super.getSingleValueOptionalFlag(hashtable, URL);
        if (string == null) {
            string = "http://localhost:8080/dai/services/";
        }
        ResourceID resourceID = new ResourceID(super.getSingleValue(hashtable, DATASOURCE));
        ServerProxy serverProxy = new ServerProxy();
        serverProxy.setDefaultBaseServicesURL(new URL(string));
        DataSourceResource dataSourceResource = serverProxy.getDataSourceResource(resourceID);
        boolean bl = Boolean.valueOf(super.getSingleValueOptionalFlag(hashtable, DESTROY));
        String string2 = super.getSingleValueOptionalFlag(hashtable, NUM_BLOCKS);
        if (string2 == null) {
            n = 0;
        } else {
            try {
                n = Integer.parseInt(string2);
                if (n <= 0) {
                    throw new IllegalArgumentException("The value for flag -n must be a positive integer");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("The value for flag -n must be a positive integer");
            }
        }
        try {
            DataSourceClient.executeRequest(dataSourceResource, n);
        }
        finally {
            if (bl) {
                dataSourceResource.destroy();
                System.out.println("Data source resource destroyed.");
            }
        }
    }

    private static void executeRequest(DataSourceResource dataSourceResource, int n) throws Exception {
        DataStreamData dataStreamData;
        System.out.println("============================DATA BEGIN=================================");
        if (n > 0) {
            do {
                System.out.println("============================BLOCK BEGIN================================");
                dataStreamData = dataSourceResource.getDataValues(n);
                DataSourceClient.printDataValues(dataStreamData.getDataValues());
                System.out.println("============================BLOCK END==================================");
            } while (dataStreamData.getStreamStatus().equals(DataStreamStatus.OPEN));
        } else {
            dataStreamData = dataSourceResource.getFully();
            DataSourceClient.printDataValues(dataStreamData.getDataValues());
        }
        if (dataStreamData.getStreamStatus().equals(DataStreamStatus.CLOSED_DUE_TO_ERROR)) {
            System.out.println("Data stream closed due to error");
        }
        System.out.println("============================DATA END===================================");
        if (dataStreamData.getStreamStatus().equals(DataStreamStatus.CLOSED_DUE_TO_ERROR)) {
            System.out.println("Data stream closed due to error");
        }
    }

    private static void printDataValues(DataValue[] dataValueArray) {
        for (int i = 0; i < dataValueArray.length; ++i) {
            DataValue dataValue = dataValueArray[i];
            if (dataValue instanceof StringData || dataValue instanceof CharData) {
                System.out.print(dataValue);
                continue;
            }
            System.out.println(dataValue);
        }
    }
}

