/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.document;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityInstanceName;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInputDescriptor;
import uk.org.ogsadai.client.toolkit.activity.RequestBuilder;
import uk.org.ogsadai.client.toolkit.activity.SimpleLiteralInputDescriptor;
import uk.org.ogsadai.client.toolkit.activity.SimplePipeInputDescriptor;
import uk.org.ogsadai.client.toolkit.document.DataValueFactory;
import uk.org.ogsadai.client.toolkit.document.NamedSingleActivityOutput;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.resource.ResourceID;
import uk.org.ogsadai.util.xml.XML;

public class RequestDocumentParser {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private static DataValueFactory mFactory = new DataValueFactory();

    public static void buildChildren(RequestBuilder requestBuilder, Element element) {
        List list = XML.getChildElements((Element)element);
        for (Element element2 : list) {
            String string = element2.getLocalName();
            if ("workflow".equals(string)) {
                RequestDocumentParser.buildChildren(requestBuilder, element2);
                continue;
            }
            if ("pipeline".equals(string)) {
                RequestDocumentParser.buildPipeline(requestBuilder, element2);
                continue;
            }
            if ("sequence".equals(string)) {
                RequestDocumentParser.buildSequence(requestBuilder, element2);
                continue;
            }
            if (!"parallel".equals(string)) continue;
            RequestDocumentParser.buildParallel(requestBuilder, element2);
        }
    }

    private static void buildSequence(RequestBuilder requestBuilder, Element element) {
        requestBuilder.startSequence();
        RequestDocumentParser.buildChildren(requestBuilder, element);
        requestBuilder.endSequence();
    }

    private static void buildParallel(RequestBuilder requestBuilder, Element element) {
        requestBuilder.startParallel();
        RequestDocumentParser.buildChildren(requestBuilder, element);
        requestBuilder.endParallel();
    }

    private static void buildPipeline(RequestBuilder requestBuilder, Element element) {
        requestBuilder.startPipeline();
        NodeList nodeList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2007/04/types", "activity");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            RequestDocumentParser.buildActivity(requestBuilder, (Element)nodeList.item(i));
        }
        requestBuilder.endPipeline();
    }

    private static void buildActivity(RequestBuilder requestBuilder, Element element) {
        String string = element.getAttribute("instanceName");
        String string2 = element.getAttribute("name");
        NodeList nodeList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2007/04/types", "input");
        ArrayList<ActivityInputDescriptor> arrayList = new ArrayList<ActivityInputDescriptor>();
        ArrayList<SingleActivityOutput> arrayList2 = new ArrayList<SingleActivityOutput>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(RequestDocumentParser.buildInput((Element)nodeList.item(i)));
        }
        ActivityInputDescriptor[] activityInputDescriptorArray = arrayList.toArray(new ActivityInputDescriptor[arrayList.size()]);
        NodeList nodeList2 = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2007/04/types", "outputStream");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            arrayList2.add(RequestDocumentParser.buildOutput((Element)nodeList2.item(i)));
        }
        SingleActivityOutput[] singleActivityOutputArray = arrayList2.toArray(new SingleActivityOutput[arrayList2.size()]);
        if (element.hasAttribute("resource")) {
            String string3 = element.getAttribute("resource");
            requestBuilder.addActivity(new ActivityName(string2), new ActivityInstanceName(string), new ResourceID(string3), activityInputDescriptorArray, singleActivityOutputArray);
        } else {
            requestBuilder.addActivity(new ActivityName(string2), new ActivityInstanceName(string), activityInputDescriptorArray, singleActivityOutputArray);
        }
    }

    private static SingleActivityOutput buildOutput(Element element) {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("pipe");
        return new NamedSingleActivityOutput(string, string2);
    }

    private static ActivityInputDescriptor buildInput(Element element) {
        SimplePipeInputDescriptor simplePipeInputDescriptor;
        String string = element.getAttribute("name");
        NodeList nodeList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2007/04/types", "inputStream");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            String string2 = element2.getAttribute("pipe");
            simplePipeInputDescriptor = new SimplePipeInputDescriptor(string, string2);
        } else {
            SimpleLiteralInputDescriptor simpleLiteralInputDescriptor = new SimpleLiteralInputDescriptor(string);
            NodeList nodeList2 = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2007/04/types", "inputLiteral");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element3 = (Element)nodeList2.item(i);
                List list = XML.getChildElements((Element)element3);
                for (Element element4 : list) {
                    DataValue dataValue = element4.getFirstChild() != null ? mFactory.getDataValue(element4.getLocalName(), element4.getFirstChild().getNodeValue()) : mFactory.getDataValue(element4.getLocalName(), null);
                    simpleLiteralInputDescriptor.add(dataValue);
                }
            }
            simplePipeInputDescriptor = simpleLiteralInputDescriptor;
        }
        return simplePipeInputDescriptor;
    }
}

