/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.document;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import uk.org.ogsadai.activity.ActivityInstanceName;
import uk.org.ogsadai.activity.request.status.ActivityProcessingStatus;
import uk.org.ogsadai.activity.request.status.ActivityResultKey;
import uk.org.ogsadai.client.toolkit.Server;
import uk.org.ogsadai.client.toolkit.Workflow;
import uk.org.ogsadai.client.toolkit.activity.RequestAndStatusHandler;
import uk.org.ogsadai.client.toolkit.activity.RequestBuilder;
import uk.org.ogsadai.client.toolkit.document.RequestDocumentParser;
import uk.org.ogsadai.client.toolkit.exception.ActivityIllegalStateException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.common.xml.XMLValidator;
import uk.org.ogsadai.exception.DAIIOException;
import uk.org.ogsadai.resource.request.RequestStatus;
import uk.org.ogsadai.util.xml.XML;

public class DocumentWorkflow
implements Workflow,
RequestAndStatusHandler {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private Document mRequestDoc;
    private Server mServer;
    private RequestStatus mRequestStatus;

    public DocumentWorkflow(Document document) {
        this.mRequestDoc = document;
    }

    public DocumentWorkflow(String string) throws FileNotFoundException {
        this.mRequestDoc = XML.fileToDocument((String)string);
    }

    public DocumentWorkflow(String string, String string2) throws FileNotFoundException, XMLParseException {
        this.mRequestDoc = XMLValidator.validate((String)string, (String)string2);
    }

    public DocumentWorkflow(String string, URL uRL) throws FileNotFoundException, XMLParseException, DAIIOException {
        try {
            this.mRequestDoc = XMLValidator.validate((String)string, (InputStream)uRL.openStream());
        }
        catch (IOException iOException) {
            throw new DAIIOException(iOException);
        }
    }

    public RequestAndStatusHandler getRequestAndStatusHandler() {
        return this;
    }

    public void buildRequest(RequestBuilder requestBuilder) throws ActivityIllegalStateException {
        RequestDocumentParser.buildChildren(requestBuilder, this.mRequestDoc.getDocumentElement());
    }

    public void processRequestStatus(RequestStatus requestStatus) {
        this.mRequestStatus = requestStatus;
    }

    public void setServer(Server server) {
        this.mServer = server;
    }

    public String toString() {
        return XML.toString((Node)this.mRequestDoc);
    }

    public ActivityProcessingStatus getActivityProcessingStatus(String string) {
        return this.mRequestStatus.getActivityProcessingStatus(new ActivityInstanceName(string));
    }

    public Iterator getResultIterator(String string, String string2) {
        ActivityInstanceName activityInstanceName = new ActivityInstanceName(string);
        return this.mRequestStatus.getDataValueIterator(activityInstanceName, string2);
    }

    public Map getResults(String string) {
        ActivityInstanceName activityInstanceName = new ActivityInstanceName(string);
        Iterator iterator = this.mRequestStatus.getActivityResults();
        HashMap hashMap = new HashMap();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ActivityResultKey activityResultKey = (ActivityResultKey)entry.getKey();
            ActivityInstanceName activityInstanceName2 = activityResultKey.getActivityInstanceName();
            if (!activityInstanceName.equals((Object)activityInstanceName2)) continue;
            hashMap.put(activityResultKey.getResultName(), entry.getValue());
        }
        return hashMap;
    }

    public RequestStatus getRequestStatus() {
        return this.mRequestStatus;
    }
}

