/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.document;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import uk.org.ogsadai.client.toolkit.exception.DataValueParseException;
import uk.org.ogsadai.client.toolkit.exception.DataValueUnknownTypeException;
import uk.org.ogsadai.common.Base64;
import uk.org.ogsadai.data.BinaryData;
import uk.org.ogsadai.data.BooleanData;
import uk.org.ogsadai.data.CharData;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.DateData;
import uk.org.ogsadai.data.DoubleData;
import uk.org.ogsadai.data.FloatData;
import uk.org.ogsadai.data.IntegerData;
import uk.org.ogsadai.data.ListBegin;
import uk.org.ogsadai.data.ListEnd;
import uk.org.ogsadai.data.LongData;
import uk.org.ogsadai.data.StringData;
import uk.org.ogsadai.resource.property.DatePropertyConvertor;

public class DataValueFactory {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private final Map mDataMapper = new HashMap();

    public DataValueFactory() {
        this.mDataMapper.put("binary", new DataConverter(){

            public DataValue convert(String string) {
                return new BinaryData(Base64.decode((String)string));
            }
        });
        this.mDataMapper.put("string", new DataConverter(){

            public DataValue convert(String string) {
                return new StringData(string);
            }
        });
        this.mDataMapper.put("charArray", new DataConverter(){

            public DataValue convert(String string) {
                return new CharData(string.toCharArray());
            }
        });
        this.mDataMapper.put("long", new DataConverter(){

            public DataValue convert(String string) {
                return new LongData(Long.parseLong(string));
            }
        });
        this.mDataMapper.put("int", new DataConverter(){

            public DataValue convert(String string) {
                return new IntegerData(Integer.parseInt(string));
            }
        });
        this.mDataMapper.put("float", new DataConverter(){

            public DataValue convert(String string) {
                return new FloatData(Float.parseFloat(string));
            }
        });
        this.mDataMapper.put("double", new DataConverter(){

            public DataValue convert(String string) {
                return new DoubleData(Double.parseDouble(string));
            }
        });
        this.mDataMapper.put("date", new DataConverter(){

            public DataValue convert(String string) throws ParseException {
                return new DateData(DatePropertyConvertor.parseXSDDate((String)string));
            }
        });
        this.mDataMapper.put("boolean", new DataConverter(){

            public DataValue convert(String string) {
                return new BooleanData(Boolean.valueOf(string).booleanValue());
            }
        });
        this.mDataMapper.put("listBegin", new DataConverter(){

            public DataValue convert(String string) {
                return ListBegin.VALUE;
            }
        });
        this.mDataMapper.put("listEnd", new DataConverter(){

            public DataValue convert(String string) {
                return ListEnd.VALUE;
            }
        });
    }

    public DataValue getDataValue(String string, String string2) {
        DataConverter dataConverter = (DataConverter)this.mDataMapper.get(string);
        if (dataConverter != null) {
            try {
                return dataConverter.convert(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataValueParseException(string, string2, (Exception)numberFormatException);
            }
            catch (ParseException parseException) {
                throw new DataValueParseException(string, string2, (Exception)parseException);
            }
        }
        throw new DataValueUnknownTypeException(string);
    }

    private static interface DataConverter {
        public DataValue convert(String var1) throws NumberFormatException, ParseException;
    }
}

