/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.util.xml;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.org.ogsadai.exception.ExternalModuleException;
import uk.org.ogsadai.util.xml.DocumentTraversalHandler;
import uk.org.ogsadai.util.xml.SimpleErrorHandler;

public class XML {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";

    public static Document getNewDocument() throws ExternalModuleException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ExternalModuleException(parserConfigurationException);
        }
    }

    public static Element getNewElement(String string, String string2, String string3) throws ExternalModuleException {
        Document document = XML.getNewDocument();
        Element element = document.createElementNS(string, string2);
        Text text = document.createTextNode(string3);
        element.appendChild(text);
        return element;
    }

    public static String getText(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Text text = (Text)nodeList.item(i);
            stringBuffer.append(text.getNodeValue());
        }
        return stringBuffer.toString();
    }

    public static Element getChildElement(Element element, String string) {
        Element element2 = null;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            element2 = (Element)nodeList.item(0);
        }
        return element2;
    }

    public static Element getChildElement(Element element, NodeFilter nodeFilter) {
        Element element2 = null;
        Iterator iterator = XML.getChildElements(element).iterator();
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            if (nodeFilter.acceptNode(element3) != 1) continue;
            element2 = element3;
            break;
        }
        return element2;
    }

    public static String getText(Element element, String string) {
        Node node = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList nodeList2;
            Node node2 = nodeList.item(i);
            if (!string.equals(node2.getLocalName()) || (nodeList2 = node2.getChildNodes()).getLength() <= 0) continue;
            node = (Text)nodeList2.item(0);
        }
        return node.getNodeValue();
    }

    public static Document toDocument(String string) {
        return XML.toDocument(new InputSource(new StringReader(string)));
    }

    public static Document fileToDocument(String string) throws FileNotFoundException {
        return XML.toDocument(new InputSource(new FileReader(string)));
    }

    public static Document toDocument(InputSource inputSource) {
        Document document;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("The inputSource argument must contain a string of well-formed XML. " + exception.getMessage());
        }
        return document;
    }

    public static String toString(Node node) {
        OutputFormat outputFormat = new OutputFormat("xml", "UTF-8", true);
        outputFormat.setLineWidth(0);
        StringWriter stringWriter = new StringWriter();
        XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
        xMLSerializer.setNamespaces(true);
        try {
            if (node instanceof Document) {
                xMLSerializer.serialize((Document)node);
            } else if (node instanceof DocumentFragment) {
                xMLSerializer.serialize((DocumentFragment)node);
            } else if (node instanceof Element) {
                xMLSerializer.serialize((Element)node);
            } else if (node instanceof Text) {
                stringWriter.write(((Text)node).getData());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public static Element toElement(String string) {
        return XML.toDocument(string).getDocumentElement();
    }

    public static List getChildElements(Element element) {
        NodeFilter nodeFilter = new NodeFilter(){

            public short acceptNode(Node node) {
                if (node.getNodeType() == 1) {
                    return 1;
                }
                return 2;
            }
        };
        return XML.getChildElements(element, nodeFilter);
    }

    public static List getChildElements(Element element, NodeFilter nodeFilter) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (nodeFilter.acceptNode(node) != 1) continue;
            arrayList.add(node);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static Document validate(Document document, Document document2) throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", new InputSource(new StringReader(XML.toString(document2))));
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new SimpleErrorHandler());
        InputSource inputSource = new InputSource(new StringReader(XML.toString(document)));
        return documentBuilder.parse(inputSource);
    }

    public static void traverse(Document document, NodeFilter nodeFilter, DocumentTraversalHandler documentTraversalHandler) {
        documentTraversalHandler.startDocument();
        XML.traverse(document.getDocumentElement(), nodeFilter, documentTraversalHandler);
        documentTraversalHandler.endDocument();
    }

    private static void traverse(Element element, NodeFilter nodeFilter, DocumentTraversalHandler documentTraversalHandler) {
        List list;
        boolean bl;
        boolean bl2 = bl = nodeFilter.acceptNode(element) == 1;
        if (bl) {
            documentTraversalHandler.startElement(element);
        }
        if ((list = XML.getChildElements(element)).size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                XML.traverse(element2, nodeFilter, documentTraversalHandler);
            }
        }
        if (bl) {
            documentTraversalHandler.endElement(element);
        }
    }

    public static List getNodes(Node node, NodeFilter nodeFilter) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Document document = node.getOwnerDocument();
        if (document instanceof DocumentTraversal) {
            Node node2;
            DocumentTraversal documentTraversal = (DocumentTraversal)((Object)document);
            NodeIterator nodeIterator = documentTraversal.createNodeIterator(node, -1, nodeFilter, false);
            while ((node2 = nodeIterator.nextNode()) != null) {
                arrayList.add(node2);
            }
        }
        return arrayList;
    }

    public static List getGrandchildren(Element element, String string) {
        ArrayList arrayList = new ArrayList();
        Element element2 = XML.getChildElement(element, string);
        if (element2 != null) {
            arrayList.addAll(XML.getChildElements(element2));
        }
        return arrayList;
    }

    public static List getElementAttributeValues(Element element, String string, String string2, String string3, String string4) {
        LinkedList<String> linkedList = new LinkedList<String>();
        NodeList nodeList = element.getElementsByTagNameNS(string, string2);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            Attr attr = element2.getAttributeNodeNS(string3, string4);
            if (attr == null) continue;
            linkedList.add(attr.getNodeValue());
        }
        return linkedList;
    }

    public static List getElementsInDocumentFragment(DocumentFragment documentFragment, String string, String string2) {
        return XML.getElementsInNodeList(documentFragment.getChildNodes(), string, string2);
    }

    public static List getElementsInNodeList(NodeList nodeList, String string, String string2) {
        LinkedList<Element> linkedList = new LinkedList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || (element = (Element)node).getNamespaceURI() != string || element.getLocalName() != string2) continue;
            linkedList.add(element);
        }
        return linkedList;
    }
}

