/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.util.graph.search;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uk.org.ogsadai.util.graph.DirectedGraph;
import uk.org.ogsadai.util.graph.Edge;
import uk.org.ogsadai.util.graph.search.DepthFirstSearchHandler;
import uk.org.ogsadai.util.graph.search.VertexMarker;

public class DirectedDepthFirstSearch {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2006 - 2007";
    private DirectedGraph mGraph;
    private DepthFirstSearchHandler mHandler;
    private final Map mMarkers = new HashMap();

    public final void search(DirectedGraph directedGraph, DepthFirstSearchHandler depthFirstSearchHandler) {
        this.mGraph = directedGraph;
        this.mHandler = depthFirstSearchHandler;
        Set set = directedGraph.getVertices();
        this.initialiseMarkers(set);
        this.startSearch(set);
    }

    private void initialiseMarkers(Set set) {
        this.mMarkers.clear();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.mMarkers.put(e, VertexMarker.WHITE);
            this.mHandler.initialiseVertex(e, this.mGraph);
        }
    }

    private void startSearch(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.mMarkers.get(e) != VertexMarker.WHITE) continue;
            this.mHandler.startVertex(e, this.mGraph);
            this.searchVertex(e);
        }
    }

    private void searchVertex(Object object) {
        this.mMarkers.put(object, VertexMarker.GREY);
        this.mHandler.discoverVertex(object, this.mGraph);
        Set set = this.mGraph.getOutgoingEdges(object);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            Object object2 = edge.getTarget();
            Object v = this.mMarkers.get(object2);
            if (v == VertexMarker.WHITE) {
                this.mHandler.treeEdge(edge, this.mGraph);
                this.searchVertex(object2);
                continue;
            }
            if (v == VertexMarker.GREY) {
                this.mHandler.backEdge(edge, this.mGraph);
                continue;
            }
            if (v != VertexMarker.BLACK) continue;
            this.mHandler.forwardOrCrossEdge(edge, this.mGraph);
        }
        this.mMarkers.put(object, VertexMarker.BLACK);
        this.mHandler.finishVertex(object, this.mGraph);
    }
}

