/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.util.graph.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import uk.org.ogsadai.util.graph.Edge;
import uk.org.ogsadai.util.graph.Graph;
import uk.org.ogsadai.util.graph.search.DepthFirstSearch;
import uk.org.ogsadai.util.graph.search.DepthFirstSearchHandler;

public final class ConnectedComponentsFinder
implements DepthFirstSearchHandler {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2006 - 2007";
    private Graph mGraph;
    private final Collection mConnectedComponents = new ArrayList();
    private Set mVertices;

    public final void startVertex(Object object, Graph graph) {
        if (this.mGraph == null) {
            this.mGraph = graph;
        }
        this.currentComponentComplete();
        this.createNextComponent();
    }

    public final void discoverVertex(Object object, Graph graph) {
        this.addToCurrentComponent(object);
    }

    private void createNextComponent() {
        this.mVertices = new HashSet();
    }

    private void addToCurrentComponent(Object object) {
        this.mVertices.add(object);
    }

    private void currentComponentComplete() {
        if (this.mVertices != null) {
            this.mConnectedComponents.add(this.mVertices);
        }
    }

    public Collection getConnectedVertexSets() {
        this.currentComponentComplete();
        return this.mConnectedComponents;
    }

    public static final Collection findConnectedComponents(Graph graph) {
        ConnectedComponentsFinder connectedComponentsFinder = new ConnectedComponentsFinder();
        DepthFirstSearch depthFirstSearch = new DepthFirstSearch();
        depthFirstSearch.search(graph, connectedComponentsFinder);
        return connectedComponentsFinder.getConnectedVertexSets();
    }

    public final void initialiseVertex(Object object, Graph graph) {
    }

    public final void finishVertex(Object object, Graph graph) {
    }

    public void treeEdge(Edge edge, Graph graph) {
    }

    public void backEdge(Edge edge, Graph graph) {
    }

    public void forwardOrCrossEdge(Edge edge, Graph graph) {
    }
}

