/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.util.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import uk.org.ogsadai.util.graph.Edge;
import uk.org.ogsadai.util.graph.EdgeOrderedDirectedGraph;

public class SimpleDirectedGraph
implements EdgeOrderedDirectedGraph {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2006 - 2007";
    private final Set mVertices = new HashSet();
    private final List mEdges = new ArrayList();

    public Set getVertices() {
        return this.mVertices;
    }

    public Set getEdges() {
        return new HashSet(this.mEdges);
    }

    public Set getAdjacentVertices(Object object) {
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = this.mEdges.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (edge.getSource() == object) {
                hashSet.add(edge.getTarget());
                continue;
            }
            if (edge.getTarget() != object) continue;
            hashSet.add(edge.getSource());
        }
        return hashSet;
    }

    public void addVertex(Object object) {
        if (!this.mVertices.contains(object)) {
            this.mVertices.add(object);
        }
    }

    public void addEdge(Edge edge) {
        this.mEdges.add(edge);
        this.addVertex(edge.getSource());
        this.addVertex(edge.getTarget());
    }

    public void removeVertex(Object object) {
        this.mVertices.remove(object);
        Iterator iterator = this.mEdges.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (edge.getSource() != object && edge.getTarget() != object) continue;
            iterator.remove();
        }
    }

    public boolean containsEdge(String string) {
        Iterator iterator = this.mEdges.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (!edge.getLabel().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Edge findEdge(String string) {
        Iterator iterator = this.mEdges.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (!edge.getLabel().equals(string)) continue;
            return edge;
        }
        return null;
    }

    public Set getIncomingEdges(Object object) {
        HashSet hashSet = new HashSet();
        this.addIncomingEdges(object, hashSet);
        return hashSet;
    }

    public Set getOutgoingEdges(Object object) {
        HashSet hashSet = new HashSet();
        this.addOutgoingEdges(object, hashSet);
        return hashSet;
    }

    public List getIncomingEdgeList(Object object) {
        ArrayList arrayList = new ArrayList();
        this.addIncomingEdges(object, arrayList);
        return arrayList;
    }

    public List getOutgoingEdgeList(Object object) {
        ArrayList arrayList = new ArrayList();
        this.addOutgoingEdges(object, arrayList);
        return arrayList;
    }

    private void addIncomingEdges(Object object, Collection collection) {
        Iterator iterator = this.mEdges.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (edge.getTarget() != object) continue;
            collection.add(edge);
        }
    }

    private void addOutgoingEdges(Object object, Collection collection) {
        Iterator iterator = this.mEdges.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (edge.getSource() != object) continue;
            collection.add(edge);
        }
    }

    public Edge getEdge(Object object, Object object2) {
        Iterator iterator = this.mEdges.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (edge.getSource() != object || edge.getTarget() != object2) continue;
            return edge;
        }
        return null;
    }

    public boolean containsVertex(Object object) {
        return this.mVertices.contains(object);
    }
}

