/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.util.graph;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import uk.org.ogsadai.util.graph.DirectedGraph;
import uk.org.ogsadai.util.graph.Edge;
import uk.org.ogsadai.util.graph.Graph;

public class DirectionlessGraphAdapter
implements Graph {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private final DirectedGraph mGraph;

    public DirectionlessGraphAdapter(DirectedGraph directedGraph) {
        this.mGraph = directedGraph;
    }

    public Set getVertices() {
        return this.mGraph.getVertices();
    }

    public Set getEdges() {
        return this.mGraph.getEdges();
    }

    public Set getAdjacentVertices(Object object) {
        HashSet<Object> hashSet = new HashSet<Object>();
        Set set = this.getEdges();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (edge.getSource() == object) {
                hashSet.add(edge.getTarget());
                continue;
            }
            if (edge.getTarget() != object) continue;
            hashSet.add(edge.getSource());
        }
        return hashSet;
    }

    public void addEdge(Edge edge) {
        this.mGraph.addEdge(edge);
    }

    public void addVertex(Object object) {
        this.mGraph.addVertex(object);
    }

    public boolean containsEdge(String string) {
        return this.mGraph.containsEdge(string);
    }

    public Edge findEdge(String string) {
        return this.mGraph.findEdge(string);
    }

    public void removeVertex(Object object) {
        this.mGraph.removeVertex(object);
    }

    public Edge getEdge(Object object, Object object2) {
        Edge edge = this.mGraph.getEdge(object, object2);
        if (edge == null) {
            edge = this.mGraph.getEdge(object2, object);
        }
        return edge;
    }

    public boolean containsVertex(Object object) {
        return this.mGraph.containsVertex(object);
    }
}

