/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.util.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import uk.org.ogsadai.util.graph.Edge;
import uk.org.ogsadai.util.graph.EdgeOrderedDirectedGraph;

public class DirectedSubgraph
implements EdgeOrderedDirectedGraph {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2007";
    private final EdgeOrderedDirectedGraph mParentGraph;
    private final Set mVertices;

    public DirectedSubgraph(EdgeOrderedDirectedGraph edgeOrderedDirectedGraph, Set set) {
        this.mParentGraph = edgeOrderedDirectedGraph;
        this.mVertices = new HashSet(set);
    }

    public Set getVertices() {
        return this.mVertices;
    }

    public Set getEdges() {
        HashSet<Edge> hashSet = new HashSet<Edge>();
        Set set = this.mParentGraph.getEdges();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (!this.mVertices.contains(edge.getSource()) || !this.mVertices.contains(edge.getTarget())) continue;
            hashSet.add(edge);
        }
        return hashSet;
    }

    public void addEdge(Edge edge) {
        throw new UnsupportedOperationException();
    }

    public void addVertex(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean containsEdge(String string) {
        throw new UnsupportedOperationException();
    }

    public Edge findEdge(String string) {
        throw new UnsupportedOperationException();
    }

    public Set getAdjacentVertices(Object object) {
        if (this.mVertices.contains(object)) {
            return this.mParentGraph.getAdjacentVertices(object);
        }
        return Collections.EMPTY_SET;
    }

    public Set getIncomingEdges(Object object) {
        if (this.mVertices.contains(object)) {
            return this.mParentGraph.getIncomingEdges(object);
        }
        return Collections.EMPTY_SET;
    }

    public Set getOutgoingEdges(Object object) {
        if (this.mVertices.contains(object)) {
            return this.mParentGraph.getOutgoingEdges(object);
        }
        return Collections.EMPTY_SET;
    }

    public Edge getEdge(Object object, Object object2) {
        Iterator iterator = this.getEdges().iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (edge.getSource() != object || edge.getTarget() != object2) continue;
            return edge;
        }
        return null;
    }

    public void removeVertex(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean containsVertex(Object object) {
        return this.mVertices.contains(object);
    }

    public List getIncomingEdgeList(Object object) {
        if (this.mVertices.contains(object)) {
            return this.mParentGraph.getIncomingEdgeList(object);
        }
        return Collections.EMPTY_LIST;
    }

    public List getOutgoingEdgeList(Object object) {
        if (this.mVertices.contains(object)) {
            return this.mParentGraph.getOutgoingEdgeList(object);
        }
        return Collections.EMPTY_LIST;
    }
}

