/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.util.concurrency;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.CancellationException;
import edu.emory.mathcs.backport.java.util.concurrent.CompletionService;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorCompletionService;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import uk.org.ogsadai.exception.RequestProcessingException;
import uk.org.ogsadai.exception.RequestTerminatedException;
import uk.org.ogsadai.exception.RequestUserException;
import uk.org.ogsadai.exception.UserExceptionMarker;
import uk.org.ogsadai.util.concurrency.TaskProcessingService;

public class SimpleTaskProcessingService
implements TaskProcessingService {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private final ExecutorService mExecutorService = Executors.newCachedThreadPool();

    public Future submit(Callable callable) {
        Future future = this.mExecutorService.submit(callable);
        return future;
    }

    public void processAll(Set set, boolean bl) throws RequestTerminatedException, RequestProcessingException, RequestUserException {
        if (set == null) {
            throw new IllegalArgumentException("The components argument must not be null.");
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new RequestTerminatedException();
        }
        ExecutorCompletionService executorCompletionService = new ExecutorCompletionService((Executor)this.mExecutorService);
        Set set2 = this.submitTasks((CompletionService)executorCompletionService, set, bl);
        this.waitForTaskCompletion((CompletionService)executorCompletionService, set2, bl);
    }

    public boolean shutdownNow() {
        this.mExecutorService.shutdownNow();
        try {
            this.mExecutorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.mExecutorService.isTerminated();
    }

    private Set submitTasks(CompletionService completionService, Set set, boolean bl) throws RequestProcessingException {
        HashSet<Future> hashSet;
        block3: {
            hashSet = new HashSet<Future>(set.size());
            try {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Callable callable = (Callable)iterator.next();
                    hashSet.add(completionService.submit(callable));
                }
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                if (!bl) break block3;
                this.cancelTasks(hashSet);
                throw new RequestProcessingException(rejectedExecutionException);
            }
        }
        return hashSet;
    }

    private void waitForTaskCompletion(CompletionService completionService, Set set, boolean bl) throws RequestProcessingException, RequestTerminatedException, RequestUserException {
        try {
            for (int i = 0; i < set.size(); ++i) {
                Future future = completionService.take();
                try {
                    future.get();
                    continue;
                }
                catch (ExecutionException executionException) {
                    if (!bl) continue;
                    this.cancelTasks(set);
                    this.handleExecutionException(executionException);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.cancelTasks(set);
            throw new RequestTerminatedException();
        }
        catch (CancellationException cancellationException) {
            this.cancelTasks(set);
            throw new RequestTerminatedException();
        }
    }

    private void cancelTasks(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Future future = (Future)iterator.next();
            future.cancel(true);
        }
    }

    private void handleExecutionException(ExecutionException executionException) throws RequestProcessingException, RequestUserException {
        Throwable throwable = executionException.getCause();
        if (throwable instanceof UserExceptionMarker) {
            throw new RequestUserException(throwable);
        }
        System.runFinalization();
        System.gc();
        throw new RequestProcessingException(throwable);
    }
}

