/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.util.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CollectiveIterator
implements Iterator {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private final Iterator mChildIterators;
    private Iterator mCurrentIterator;

    public CollectiveIterator(Collection collection) {
        this.mChildIterators = collection.iterator();
        this.nextChild();
    }

    public boolean hasNext() {
        while (this.mCurrentIterator != null && !this.mCurrentIterator.hasNext()) {
            this.nextChild();
        }
        return this.mCurrentIterator != null;
    }

    public Object next() {
        Object var1_1 = null;
        while (var1_1 == null && this.mCurrentIterator != null) {
            if (this.mCurrentIterator.hasNext()) {
                var1_1 = this.mCurrentIterator.next();
                continue;
            }
            this.nextChild();
        }
        if (this.mCurrentIterator == null) {
            throw new NoSuchElementException("The iterator has no more elements.");
        }
        return var1_1;
    }

    public void remove() {
        if (this.mCurrentIterator != null) {
            this.mCurrentIterator.remove();
        }
    }

    private void nextChild() {
        this.mCurrentIterator = this.mChildIterators.hasNext() ? (Iterator)this.mChildIterators.next() : null;
    }
}

