/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;

public class IOUtilities {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";

    public static void streamData(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        byte[] byArray = new byte[1024];
        while ((n = bufferedInputStream.read(byArray)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.flush();
    }

    public static void streamData(Reader reader, Writer writer) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(reader);
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        char[] cArray = new char[512];
        while ((n = bufferedReader.read(cArray)) != -1) {
            bufferedWriter.write(cArray, 0, n);
        }
        bufferedWriter.flush();
    }

    public static void streamData(Reader reader, DataOutputStream dataOutputStream) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(reader);
        char[] cArray = new char[512];
        while ((n = bufferedReader.read(cArray)) != -1) {
            dataOutputStream.writeBytes(new String(cArray, 0, n));
        }
        dataOutputStream.flush();
    }

    public static OutputStream openOutputStream(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoInput(false);
        uRLConnection.setDoOutput(true);
        return uRLConnection.getOutputStream();
    }

    public static char[] readData(Reader reader) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtilities.streamData(reader, charArrayWriter);
        charArrayWriter.close();
        return charArrayWriter.toCharArray();
    }

    public static byte[] readData(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtilities.streamData(inputStream, byteArrayOutputStream);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

