/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.tuple;

import java.math.BigDecimal;
import uk.org.ogsadai.tuple.TupleTypeConversionException;
import uk.org.ogsadai.tuple.UnsupportedTupleTypeConversion;

public class TupleTypesConverter {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";

    public static Object convertFromString(String string, int n) throws UnsupportedTupleTypeConversion, TupleTypeConversionException {
        Object object = null;
        try {
            switch (n) {
                case 17: {
                    object = new BigDecimal(string);
                    break;
                }
                case 2: {
                    object = new Boolean(string);
                    break;
                }
                case 7: {
                    if (string.length() == 1) {
                        object = new Character(string.charAt(0));
                        break;
                    }
                    throw new TupleTypeConversionException("String data contains more than one character");
                }
                case 8: {
                    object = new Double(string);
                    break;
                }
                case 3: {
                    object = new Float(string);
                    break;
                }
                case 4: {
                    object = new Integer(string);
                    break;
                }
                case 5: {
                    object = new Long(string);
                    break;
                }
                case 9: {
                    object = new Short(string);
                    break;
                }
                case 6: {
                    object = string;
                    break;
                }
                default: {
                    throw new UnsupportedTupleTypeConversion(6, n);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new TupleTypeConversionException(numberFormatException);
        }
        return object;
    }
}

