/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.tuple;

import java.util.ArrayList;
import java.util.List;
import uk.org.ogsadai.tuple.ColumnMetadata;
import uk.org.ogsadai.tuple.ColumnNotFoundException;
import uk.org.ogsadai.tuple.SimpleColumnMetadata;
import uk.org.ogsadai.tuple.TupleMetadata;

public class SimpleTupleMetadata
implements TupleMetadata {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2002 - 2007.";
    private List mColumnMetadata;
    private String mDescription;

    public SimpleTupleMetadata(String string, List list) {
        this.mColumnMetadata = new ArrayList(list);
        this.mDescription = string;
    }

    public SimpleTupleMetadata(List list) {
        this("", list);
    }

    public SimpleTupleMetadata(TupleMetadata tupleMetadata, TupleMetadata tupleMetadata2) {
        this("", tupleMetadata, tupleMetadata2);
    }

    public SimpleTupleMetadata(String string, TupleMetadata tupleMetadata, TupleMetadata tupleMetadata2) {
        this(string, "", tupleMetadata, "", tupleMetadata2);
    }

    public SimpleTupleMetadata(String string, TupleMetadata tupleMetadata, String string2, TupleMetadata tupleMetadata2) {
        this("", string, tupleMetadata, string2, tupleMetadata2);
    }

    public SimpleTupleMetadata(String string, String string2, TupleMetadata tupleMetadata, String string3, TupleMetadata tupleMetadata2) {
        SimpleColumnMetadata simpleColumnMetadata;
        ColumnMetadata columnMetadata;
        int n;
        int n2 = tupleMetadata.getColumnCount();
        int n3 = tupleMetadata2.getColumnCount();
        this.mColumnMetadata = new ArrayList(n2 + n3);
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            columnMetadata = tupleMetadata.getColumnMetadata(n);
            simpleColumnMetadata = new SimpleColumnMetadata(string2 + columnMetadata.getName(), columnMetadata.getType(), columnMetadata.getPrecision(), columnMetadata.isNullable(), columnMetadata.getColumnDisplaySize());
            this.mColumnMetadata.add(n4++, simpleColumnMetadata);
        }
        for (n = 0; n < n3; ++n) {
            columnMetadata = tupleMetadata2.getColumnMetadata(n);
            simpleColumnMetadata = new SimpleColumnMetadata(string3 + columnMetadata.getName(), columnMetadata.getType(), columnMetadata.getPrecision(), columnMetadata.isNullable(), columnMetadata.getColumnDisplaySize());
            this.mColumnMetadata.add(n4++, simpleColumnMetadata);
        }
        this.mDescription = string;
    }

    public int getColumnCount() {
        return this.mColumnMetadata.size();
    }

    public ColumnMetadata getColumnMetadata(int n) throws ColumnNotFoundException {
        try {
            return (SimpleColumnMetadata)this.mColumnMetadata.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public ColumnMetadata getColumnMetadata(String string) throws ColumnNotFoundException {
        for (int i = 0; i < this.mColumnMetadata.size(); ++i) {
            if (!((SimpleColumnMetadata)this.mColumnMetadata.get(i)).getName().equals(string)) continue;
            return (SimpleColumnMetadata)this.mColumnMetadata.get(i);
        }
        throw new ColumnNotFoundException(string);
    }

    public int getColumnMetadataPosition(String string) {
        for (int i = 0; i < this.mColumnMetadata.size(); ++i) {
            if (!((SimpleColumnMetadata)this.mColumnMetadata.get(i)).getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleTupleMetadata)) {
            return false;
        }
        SimpleTupleMetadata simpleTupleMetadata = (SimpleTupleMetadata)object;
        return this.mDescription.equals(simpleTupleMetadata.mDescription) && ((Object)this.mColumnMetadata).equals(simpleTupleMetadata.mColumnMetadata);
    }

    public int hashCode() {
        return this.mDescription.hashCode() + ((Object)this.mColumnMetadata).hashCode();
    }

    public String toString() {
        String string = new String("<metadata>");
        for (int i = 0; i < this.getColumnCount(); ++i) {
            try {
                string = string + this.getColumnMetadata(i);
            }
            catch (ColumnNotFoundException columnNotFoundException) {
                return "Invalid column index";
            }
            if (this.getColumnCount() - i <= 1) continue;
            string = string + ",";
        }
        string = string + "</metadata>\n";
        return string;
    }
}

