/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.tuple;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import uk.org.ogsadai.tuple.ColumnNotFoundException;
import uk.org.ogsadai.tuple.Null;
import uk.org.ogsadai.tuple.SimpleClob;
import uk.org.ogsadai.tuple.Tuple;
import uk.org.ogsadai.tuple.TupleMetadata;

public class SimpleTuple
implements Tuple {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2002 - 2007.";
    private Null mODNULL = Null.getValue();
    private boolean mWasNull = false;
    private List mElements;

    public SimpleTuple(List list) {
        this.mElements = new ArrayList(list);
    }

    public SimpleTuple(Tuple tuple, Tuple tuple2) {
        Object object;
        int n;
        int n2 = tuple.getColumnCount();
        int n3 = tuple2.getColumnCount();
        this.mElements = new ArrayList(n2 + n3);
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            object = tuple.getObject(n);
            this.mElements.add(n4++, object);
        }
        for (n = 0; n < n3; ++n) {
            object = tuple2.getObject(n);
            this.mElements.add(n4++, object);
        }
    }

    public int getColumnCount() {
        return this.mElements.size();
    }

    public Object getObject(int n) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(n);
            this.mWasNull = e == this.mODNULL;
            return e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public boolean getBoolean(int n) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(n);
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return false;
            }
            return (Boolean)e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public float getFloat(int n) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(n);
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return 0.0f;
            }
            if (e instanceof Number) {
                return ((Number)e).floatValue();
            }
            return Float.parseFloat(e.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public int getInt(int n) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(n);
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return 0;
            }
            if (e instanceof Number) {
                return ((Number)e).intValue();
            }
            return Integer.parseInt(e.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public long getLong(int n) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(n);
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return 0L;
            }
            if (e instanceof Number) {
                return ((Number)e).longValue();
            }
            return Long.parseLong(e.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public String getString(int n) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(n);
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return null;
            }
            return e.toString();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public char getChar(int n) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(n);
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return '\u0000';
            }
            return ((Character)e).charValue();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public double getDouble(int n) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(n);
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return 0.0;
            }
            if (e instanceof Number) {
                return ((Number)e).doubleValue();
            }
            return Double.parseDouble(e.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public short getShort(int n) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(n);
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return 0;
            }
            if (e instanceof Number) {
                return ((Number)e).shortValue();
            }
            return Short.parseShort(e.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public File getFile(int n) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(n);
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return null;
            }
            return ((File)e).getAbsoluteFile();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public Date getDate(int n) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(n);
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return null;
            }
            return (Date)e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public Time getTime(int n) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(n);
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return null;
            }
            return (Time)e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public Timestamp getTimestamp(int n) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(n);
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return null;
            }
            return (Timestamp)e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public BigDecimal getBigDecimal(int n) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(n);
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return null;
            }
            return (BigDecimal)e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public Blob getBlob(int n) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(n);
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return null;
            }
            return (Blob)e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public Clob getClob(int n) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(n);
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return null;
            }
            if (e instanceof String) {
                return new SimpleClob(((String)e).toCharArray());
            }
            return (Clob)e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(n);
        }
    }

    public Object getObject(TupleMetadata tupleMetadata, String string) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(tupleMetadata.getColumnMetadataPosition(string));
            this.mWasNull = e == this.mODNULL;
            return e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(string);
        }
    }

    public boolean getBoolean(TupleMetadata tupleMetadata, String string) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(tupleMetadata.getColumnMetadataPosition(string));
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return false;
            }
            return (Boolean)e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(string);
        }
    }

    public float getFloat(TupleMetadata tupleMetadata, String string) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(tupleMetadata.getColumnMetadataPosition(string));
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return 0.0f;
            }
            if (e instanceof Number) {
                return ((Number)e).floatValue();
            }
            return Float.parseFloat(e.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(string);
        }
    }

    public int getInt(TupleMetadata tupleMetadata, String string) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(tupleMetadata.getColumnMetadataPosition(string));
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return 0;
            }
            if (e instanceof Number) {
                return ((Number)e).intValue();
            }
            return Integer.parseInt(e.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(string);
        }
    }

    public long getLong(TupleMetadata tupleMetadata, String string) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(tupleMetadata.getColumnMetadataPosition(string));
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return 0L;
            }
            if (e instanceof Number) {
                return ((Number)e).longValue();
            }
            return Long.parseLong(e.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(string);
        }
    }

    public String getString(TupleMetadata tupleMetadata, String string) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(tupleMetadata.getColumnMetadataPosition(string));
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return null;
            }
            return (String)e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(string);
        }
    }

    public char getChar(TupleMetadata tupleMetadata, String string) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(tupleMetadata.getColumnMetadataPosition(string));
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return '\u0000';
            }
            return ((Character)e).charValue();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(string);
        }
    }

    public double getDouble(TupleMetadata tupleMetadata, String string) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(tupleMetadata.getColumnMetadataPosition(string));
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return 0.0;
            }
            if (e instanceof Number) {
                return ((Number)e).doubleValue();
            }
            return Double.parseDouble(e.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(string);
        }
    }

    public short getShort(TupleMetadata tupleMetadata, String string) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(tupleMetadata.getColumnMetadataPosition(string));
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return 0;
            }
            if (e instanceof Number) {
                return ((Number)e).shortValue();
            }
            return Short.parseShort(e.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(string);
        }
    }

    public File getFile(TupleMetadata tupleMetadata, String string) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(tupleMetadata.getColumnMetadataPosition(string));
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return null;
            }
            return (File)e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(string);
        }
    }

    public Date getDate(TupleMetadata tupleMetadata, String string) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(tupleMetadata.getColumnMetadataPosition(string));
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return null;
            }
            return (Date)e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(string);
        }
    }

    public Time getTime(TupleMetadata tupleMetadata, String string) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(tupleMetadata.getColumnMetadataPosition(string));
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return null;
            }
            return (Time)e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(string);
        }
    }

    public Timestamp getTimestamp(TupleMetadata tupleMetadata, String string) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(tupleMetadata.getColumnMetadataPosition(string));
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return null;
            }
            return (Timestamp)e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(string);
        }
    }

    public BigDecimal getBigDecimal(TupleMetadata tupleMetadata, String string) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(tupleMetadata.getColumnMetadataPosition(string));
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return null;
            }
            return (BigDecimal)e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(string);
        }
    }

    public Blob getBlob(TupleMetadata tupleMetadata, String string) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(tupleMetadata.getColumnMetadataPosition(string));
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return null;
            }
            return (Blob)e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(string);
        }
    }

    public Clob getClob(TupleMetadata tupleMetadata, String string) throws ColumnNotFoundException {
        try {
            Object e = this.mElements.get(tupleMetadata.getColumnMetadataPosition(string));
            boolean bl = this.mWasNull = e == this.mODNULL;
            if (this.mWasNull) {
                return null;
            }
            if (e instanceof String) {
                return new SimpleClob(((String)e).toCharArray());
            }
            return (Clob)e;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ColumnNotFoundException(string);
        }
    }

    public boolean wasNull() {
        return this.mWasNull;
    }

    public String toString() {
        String string = new String("<tuple>");
        for (int i = 0; i < this.getColumnCount(); ++i) {
            try {
                string = string + this.getObject(i).toString();
            }
            catch (ColumnNotFoundException columnNotFoundException) {
                return "Invalid column index";
            }
            if (this.getColumnCount() - i <= 1) continue;
            string = string + ",";
        }
        string = string + "</tuple>\n";
        return string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleTuple)) {
            return false;
        }
        SimpleTuple simpleTuple = (SimpleTuple)object;
        return ((Object)this.mElements).equals(simpleTuple.mElements);
    }

    public int hashCode() {
        return ((Object)this.mElements).hashCode();
    }
}

