/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.tuple;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.util.IOUtilities;

public class SimpleClob
implements Clob {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private static final DAILogger LOG = DAILogger.getLogger(SimpleClob.class);
    private final char[] mData;

    public SimpleClob(char[] cArray) {
        this.mData = cArray;
    }

    public SimpleClob(Clob clob) throws SQLException, IOException {
        this(IOUtilities.readData(clob.getCharacterStream()));
    }

    public SimpleClob(Object object) throws SQLException, IOException {
        if (object == null) {
            this.mData = new char[0];
        } else if (object instanceof Clob) {
            Clob clob = (Clob)object;
            this.mData = IOUtilities.readData(clob.getCharacterStream());
        } else {
            this.mData = object instanceof char[] ? (char[])object : object.toString().toCharArray();
        }
    }

    public Reader getCharacterStream() {
        return new CharArrayReader(this.mData);
    }

    public long length() {
        return this.mData.length;
    }

    public String toString() {
        return new String(this.mData);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SimpleClob) {
            return Arrays.equals(this.mData, ((SimpleClob)object).mData);
        }
        return false;
    }

    public int hashCode() {
        return this.mData.hashCode();
    }

    public InputStream getAsciiStream() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getSubString(long l, int n) throws SQLException {
        if (l < 0L || l > this.length()) {
            throw new IllegalArgumentException("Position must be between 0 and " + this.length());
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int n2 = Math.min(this.mData.length - (int)l, n);
        charArrayWriter.write(this.mData, (int)l, n2);
        return charArrayWriter.toString();
    }

    public long position(String string, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public long position(Clob clob, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Writer setCharacterStream(long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int setString(long l, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void truncate(long l) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

