/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.tuple;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.util.IOUtilities;

public class SimpleBlob
implements Blob {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2002 - 2007.";
    private static final DAILogger LOG = DAILogger.getLogger(SimpleBlob.class);
    private final byte[] mData;

    public SimpleBlob(byte[] byArray) {
        this.mData = byArray;
    }

    public SimpleBlob(Blob blob) throws SQLException, IOException {
        this(IOUtilities.readData(blob.getBinaryStream()));
    }

    public SimpleBlob(Object object) throws SQLException, IOException {
        this.mData = object == null ? new byte[0] : (object instanceof Blob ? IOUtilities.readData(((Blob)object).getBinaryStream()) : (object instanceof byte[] ? (byte[])object : object.toString().getBytes()));
    }

    public InputStream getBinaryStream() {
        return new ByteArrayInputStream(this.mData);
    }

    public long length() {
        return this.mData.length;
    }

    public String toString() {
        return "BLOB(length=" + this.length() + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SimpleBlob) {
            return Arrays.equals(this.mData, ((SimpleBlob)object).mData);
        }
        return false;
    }

    public int hashCode() {
        return this.mData.hashCode();
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l < 1L || l > this.length()) {
            throw new IllegalArgumentException("Offset must be between 1 and " + this.length() + ".");
        }
        int n2 = Math.min(this.mData.length - (int)l + 1, n);
        byte[] byArray = new byte[n2];
        System.arraycopy(this.mData, (int)l - 1, byArray, 0, n2);
        return byArray;
    }

    public long position(byte[] byArray, long l) {
        throw new UnsupportedOperationException();
    }

    public long position(Blob blob, long l) {
        throw new UnsupportedOperationException();
    }

    public OutputStream setBinaryStream(long l) {
        throw new UnsupportedOperationException();
    }

    public int setBytes(long l, byte[] byArray) {
        throw new UnsupportedOperationException();
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public void truncate(long l) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

