/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.exception;

import uk.org.ogsadai.common.msgs.DAIUniqueID;
import uk.org.ogsadai.common.msgs.MessageLoader;
import uk.org.ogsadai.exception.DAIExceptionInformation;
import uk.org.ogsadai.exception.ErrorID;

public abstract class DAIUncheckedException
extends RuntimeException
implements DAIExceptionInformation {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2002 - 2007";
    private ErrorID mErrorID;
    private Object[] mParameters;
    private DAIUniqueID mUniqueID;

    protected DAIUncheckedException() {
        this.mErrorID = null;
        this.mParameters = new Object[0];
        this.mUniqueID = DAIUniqueID.newInstance();
    }

    public DAIUncheckedException(ErrorID errorID) {
        this.mErrorID = errorID;
        this.mParameters = new Object[0];
        this.mUniqueID = DAIUniqueID.newInstance();
    }

    public DAIUncheckedException(ErrorID errorID, Object[] objectArray) {
        this.mErrorID = errorID;
        this.mParameters = objectArray;
        this.mUniqueID = DAIUniqueID.newInstance();
    }

    public ErrorID getErrorID() {
        return this.mErrorID;
    }

    public Object[] getParameters() {
        if (this.mParameters != null) {
            return this.mParameters;
        }
        return new Object[0];
    }

    public DAIUniqueID getExceptionID() {
        return this.mUniqueID;
    }

    public boolean hasChild() {
        return super.getCause() != null;
    }

    public String getMessage() {
        return MessageLoader.getMessage(this.mErrorID, this.mParameters, this.mUniqueID);
    }

    public String getLocalizedMessage() {
        return MessageLoader.getLocalizedMessage(this.mErrorID, this.mParameters, this.mUniqueID);
    }

    protected void setErrorID(ErrorID errorID) {
        this.mErrorID = errorID;
    }

    protected void setParameters(Object[] objectArray) {
        this.mParameters = objectArray;
    }
}

