/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.dbcreate;

import java.sql.Connection;
import java.sql.SQLException;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;
import uk.org.ogsadai.dbcreate.CreateTestDB;
import uk.org.ogsadai.dbcreate.CreateTestDatabaseException;

public class CreateTestExistDB
extends CreateTestDB {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) International Business Machines Corporation, 2002-2005, Copyright (c) The University of Edinburgh,  2002-2007.";
    private String mNewCollectionName;
    private String mNewSubCollectionName;

    public CreateTestExistDB(String[] stringArray) {
        super(stringArray);
    }

    public static void main(String[] stringArray) {
        new CreateTestExistDB(stringArray);
    }

    protected void setDefaultSettings() {
        this.mDBMS = "eXist";
        this.mDriver = "org.exist.xmldb.DatabaseImpl";
        this.mHost = "localhost";
        this.mPort = "8080";
        this.mDatabase = "db";
        this.mNewCollectionName = "littleblackbook";
        this.mNewSubCollectionName = "subbook";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void populateDatabase() throws CreateTestDatabaseException {
        Collection collection = null;
        Collection collection2 = null;
        Collection collection3 = null;
        try {
            XMLResource xMLResource;
            String string;
            String string2;
            int n;
            Class<?> clazz = Class.forName(this.mDriver);
            Database database = (Database)clazz.newInstance();
            DatabaseManager.registerDatabase((Database)database);
            String string3 = "xmldb:exist://" + this.mHost + ":" + this.mPort + "/exist/xmlrpc/" + this.mDatabase + "/";
            System.out.println("Opening base collection: " + string3);
            collection = DatabaseManager.getCollection((String)string3);
            CollectionManagementService collectionManagementService = (CollectionManagementService)collection.getService("CollectionManagementService", "1.0");
            collection2 = collection.getChildCollection(this.mNewCollectionName);
            if (collection2 != null) {
                throw new CreateTestDatabaseException("Collection " + this.mNewCollectionName + " already exists");
            }
            System.out.println("Creating new collection named '" + this.mNewCollectionName + "'.");
            collection2 = collectionManagementService.createCollection(this.mNewCollectionName);
            System.out.println("Adding " + this.mNumberOfEntries + " documents to '" + this.mNewCollectionName + "'...");
            for (n = 1; n <= this.mNumberOfEntries; ++n) {
                string2 = String.valueOf(n);
                string = this.makeDocument(n);
                xMLResource = (XMLResource)collection2.createResource(string2, "XMLResource");
                xMLResource.setContent((Object)string);
                collection2.storeResource((Resource)xMLResource);
            }
            collection3 = collection2.getChildCollection(this.mNewSubCollectionName);
            if (collection3 != null) {
                throw new CreateTestDatabaseException("Collection " + this.mNewSubCollectionName + " already exists");
            }
            System.out.println("Creating new subcollection named '" + this.mNewSubCollectionName + "'.");
            collection3 = collectionManagementService.createCollection(this.mNewCollectionName + "/" + this.mNewSubCollectionName);
            System.out.println("Adding " + this.mNumberOfEntries + " documents to '" + this.mNewSubCollectionName + "'...");
            n = 1;
            while (true) {
                if (n > this.mNumberOfEntries / 10) {
                    this.closeCollection(collection2);
                    this.closeCollection(collection);
                    return;
                }
                string2 = String.valueOf(n);
                string = this.makeDocument(n);
                xMLResource = (XMLResource)collection3.createResource(string2, "XMLResource");
                xMLResource.setContent((Object)string);
                collection3.storeResource((Resource)xMLResource);
                ++n;
            }
        }
        catch (XMLDBException xMLDBException) {
            try {
                throw new CreateTestDatabaseException(xMLDBException);
                catch (ClassNotFoundException classNotFoundException) {
                    throw new CreateTestDatabaseException("Cannot find driver class " + this.mDriver, classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    throw new CreateTestDatabaseException("Cannot instantiate driver class " + this.mDriver, instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new CreateTestDatabaseException("Cannot instantiate driver class " + this.mDriver, illegalAccessException);
                }
            }
            catch (Throwable throwable) {
                this.closeCollection(collection2);
                this.closeCollection(collection);
                throw throwable;
            }
        }
    }

    private void closeCollection(Collection collection) {
        if (collection != null) {
            try {
                collection.close();
            }
            catch (XMLDBException xMLDBException) {
                // empty catch block
            }
        }
    }

    private String makeDocument(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<entry id='" + n + "'>\n");
        stringBuffer.append("  <name>");
        stringBuffer.append(this.mData.getName(n));
        stringBuffer.append("</name>\n");
        stringBuffer.append("  <address>");
        stringBuffer.append(this.mData.getAddress(n));
        stringBuffer.append("</address>\n");
        stringBuffer.append("  <phone>");
        stringBuffer.append(this.mData.getPhone(n));
        stringBuffer.append("</phone>\n");
        stringBuffer.append("</entry>");
        return stringBuffer.toString();
    }

    protected boolean setupArguments(String[] stringArray) {
        if (stringArray.length % 2 == 1) {
            return false;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            if (stringArray[i].toLowerCase().equals("-driverclass")) {
                this.mDriver = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-host")) {
                this.mHost = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-port")) {
                this.mPort = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-database")) {
                this.mDatabase = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-collectionname")) {
                this.mNewCollectionName = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-documents")) {
                this.mNumberOfEntries = Integer.parseInt(stringArray[i + 1]);
                continue;
            }
            return false;
        }
        return true;
    }

    protected void printUsage() {
        System.out.println("Usage:\n\n\tjava uk.org.ogsadai.client.dbcreate.CreateTest" + this.mDBMS + "DB " + "[-driverclass " + this.mDBMS + "DriverClass] \n\t\t" + "[-host " + this.mDBMS + "HostName] " + "[-port " + this.mDBMS + "PortNumber] " + "[-database " + this.mDBMS + "DatabaseName] \n\t\t" + "[-collectionname NameOfCollectionToCreate] " + "[-documents NumberOfDocumentsToCreate]");
    }

    protected void printVariables(String string) {
        System.out.println(string + " Settings:" + "\n\t" + this.mDBMS + "DriverClass:    \t\t" + this.mDriver + "\n\t" + this.mDBMS + "HostName:       \t\t" + this.mHost + "\n\t" + this.mDBMS + "PortNumber:     \t\t" + this.mPort + "\n\t" + this.mDBMS + "DatabaseName:   \t\t" + this.mDatabase + "\n\tNameOfCollectionToCreate: \t" + this.mNewCollectionName + "\n\tNumberOfDocumentsToCreate:\t" + this.mNumberOfEntries);
    }

    protected void dropTableIfExists(Connection connection) throws SQLException {
    }

    protected String getConnectionURL() {
        return "xmldb:exist://" + this.mHost + ":" + this.mPort + "/exist/xmlrpc/" + this.mDatabase + "/";
    }
}

