/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.dbcreate;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import uk.org.ogsadai.dbcreate.CreateTestDatabaseException;
import uk.org.ogsadai.dbcreate.DataCreator;

public abstract class CreateTestDB {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2007";
    protected final DataCreator mData = new DataCreator();
    protected String mDBMS;
    protected String mDriver;
    protected String mHost;
    protected String mPort;
    protected String mDatabase;
    protected String mUsername;
    protected String mPassword;
    protected String mTable;
    protected int mNumberOfEntries = 10000;

    public CreateTestDB(String[] stringArray) {
        this.setDefaultSettings();
        if (this.setupArguments(stringArray)) {
            try {
                this.printVariables(this.mDBMS);
                this.populateDatabase();
                System.out.println("Test database created successfully!");
            }
            catch (CreateTestDatabaseException createTestDatabaseException) {
                System.out.println(createTestDatabaseException.getLocalizedMessage());
            }
        } else {
            this.printUsage();
            this.printVariables("Default");
        }
    }

    protected abstract void setDefaultSettings();

    protected void populateDatabase() throws CreateTestDatabaseException {
        this.loadDriver();
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(this.getConnectionURL(), this.mUsername, this.mPassword);
            this.createDatabase(connection);
            this.dropTableIfExists(connection);
            this.createTable(connection);
        }
        catch (SQLException sQLException) {
            throw new CreateTestDatabaseException(sQLException);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected boolean setupArguments(String[] stringArray) {
        if (stringArray.length % 2 == 1) {
            return false;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            if (stringArray[i].toLowerCase().equals("-driverclass")) {
                this.mDriver = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-host")) {
                this.mHost = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-port")) {
                this.mPort = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-database")) {
                this.mDatabase = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-username")) {
                this.mUsername = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-password")) {
                this.mPassword = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-tablename")) {
                this.mTable = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-rows")) {
                this.mNumberOfEntries = Integer.parseInt(stringArray[i + 1]);
                continue;
            }
            return false;
        }
        return true;
    }

    protected void printUsage() {
        System.out.println("Usage:\njava uk.org.ogsadai.client.dbcreate.CreateTest" + this.mDBMS + "DB " + "[-driverclass " + this.mDBMS + "DriverClass] \n\t\t" + "[-host " + this.mDBMS + "HostName] " + "[-port " + this.mDBMS + "PortNumber] " + "[-database " + this.mDBMS + "DatabaseName] \n\t\t" + "[-username " + this.mDBMS + "UserName] " + "[-password " + this.mDBMS + "Password] \n\t\t" + "[-tablename NameOfTableToCreate] " + "[-rows NumberOfRowsToCreate]");
    }

    protected void printVariables(String string) {
        System.out.println(string + " Settings:" + "\n\t" + this.mDBMS + "DriverClass:    \t" + this.mDriver + "\n\t" + this.mDBMS + "HostName:       \t" + this.mHost + "\n\t" + this.mDBMS + "PortNumber:     \t" + this.mPort + "\n\t" + this.mDBMS + "DatabaseName:   \t" + this.mDatabase + "\n\t" + this.mDBMS + "UserName:       \t" + this.mUsername + "\n\t" + this.mDBMS + "Password:       \t" + this.mPassword + "\n\tNameOfTableToCreate: \t" + this.mTable + "\n\tNumberOfRowsToCreate:\t" + this.mNumberOfEntries);
    }

    protected void loadDriver() throws CreateTestDatabaseException {
        try {
            Class.forName(this.mDriver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CreateTestDatabaseException("Cannot find driver class " + this.mDriver, classNotFoundException);
        }
    }

    protected abstract String getConnectionURL();

    protected void createDatabase(Connection connection) {
    }

    protected abstract void dropTableIfExists(Connection var1) throws SQLException;

    protected String getCreateTableStatement() {
        return "CREATE TABLE " + this.mTable + " (id INTEGER, name VARCHAR(64), " + "address VARCHAR(128), phone VARCHAR(20))";
    }

    protected String getInsertRowStatement() {
        return "INSERT INTO " + this.mTable + " (id, name, address, phone) VALUES (?, ?, ?, ?)";
    }

    protected void createTable(Connection connection) throws SQLException {
        System.out.println("Creating " + this.mTable + " table in database");
        Statement statement = connection.createStatement();
        statement.executeUpdate(this.getCreateTableStatement());
        System.out.println("Preparing insert statement");
        PreparedStatement preparedStatement = connection.prepareStatement(this.getInsertRowStatement());
        System.out.print("Adding " + this.mNumberOfEntries + " entries to '" + this.mTable + "' ...");
        for (int i = 1; i <= this.mNumberOfEntries; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, this.mData.getName(i));
            preparedStatement.setString(3, this.mData.getAddress(i));
            preparedStatement.setString(4, this.mData.getPhone(i));
            preparedStatement.execute();
            if (i % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.println();
    }
}

