/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset.tuple;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import uk.org.ogsadai.common.Base64;
import uk.org.ogsadai.converters.webrowset.tuple.ColumnStrategy;
import uk.org.ogsadai.tuple.ColumnMetadata;
import uk.org.ogsadai.tuple.SimpleBlob;
import uk.org.ogsadai.tuple.SimpleClob;

public class ColumnStrategyFactory {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private static ColumnStrategy DOUBLE = new ColumnStrategy(){

        public Object getObject(String string) {
            return Double.valueOf(string);
        }
    };
    private static ColumnStrategy INTEGER = new ColumnStrategy(){

        public Object getObject(String string) {
            return Integer.valueOf(string);
        }
    };
    private static ColumnStrategy LONG = new ColumnStrategy(){

        public Object getObject(String string) {
            return Long.valueOf(string);
        }
    };
    private static ColumnStrategy SHORT = new ColumnStrategy(){

        public Object getObject(String string) {
            return Short.valueOf(string);
        }
    };
    private static ColumnStrategy FLOAT = new ColumnStrategy(){

        public Object getObject(String string) {
            return Float.valueOf(string);
        }
    };
    private static ColumnStrategy BIG_DECIMAL = new ColumnStrategy(){

        public Object getObject(String string) {
            return new BigDecimal(string);
        }
    };
    private static ColumnStrategy BLOB = new ColumnStrategy(){

        public Object getObject(String string) {
            return new SimpleBlob(Base64.decode(string));
        }
    };
    private static ColumnStrategy CLOB = new ColumnStrategy(){

        public Object getObject(String string) {
            return new SimpleClob(string.toCharArray());
        }
    };
    private static ColumnStrategy BOOLEAN = new ColumnStrategy(){

        public Object getObject(String string) {
            return Boolean.valueOf(string);
        }
    };
    private static ColumnStrategy BYTE_ARRAY = new ColumnStrategy(){

        public Object getObject(String string) {
            return Base64.decode(string);
        }
    };
    private static ColumnStrategy CHAR = new ColumnStrategy(){

        public Object getObject(String string) {
            return new Character(string.charAt(0));
        }
    };
    private static ColumnStrategy STRING = new ColumnStrategy(){

        public Object getObject(String string) {
            return string;
        }
    };
    private static ColumnStrategy DATE = new ColumnStrategy(){

        public Object getObject(String string) {
            return Date.valueOf(string);
        }
    };
    private static ColumnStrategy TIME = new ColumnStrategy(){

        public Object getObject(String string) {
            return Time.valueOf(string);
        }
    };
    private static ColumnStrategy TIMESTAMP = new ColumnStrategy(){

        public Object getObject(String string) {
            return Timestamp.valueOf(string);
        }
    };

    private ColumnStrategyFactory() {
    }

    public static ColumnStrategy getColumnStrategy(ColumnMetadata columnMetadata) {
        int n = columnMetadata.getType();
        switch (n) {
            case 17: {
                return BIG_DECIMAL;
            }
            case 8: {
                return DOUBLE;
            }
            case 3: {
                return FLOAT;
            }
            case 4: {
                return INTEGER;
            }
            case 5: {
                return LONG;
            }
            case 15: {
                return BLOB;
            }
            case 16: {
                return CLOB;
            }
            case 2: {
                return BOOLEAN;
            }
            case 10: {
                return BYTE_ARRAY;
            }
            case 7: {
                return CHAR;
            }
            case 12: {
                return DATE;
            }
            case 6: {
                return STRING;
            }
            case 9: {
                return SHORT;
            }
            case 13: {
                return TIME;
            }
            case 14: {
                return TIMESTAMP;
            }
        }
        return STRING;
    }
}

