/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset.resultset.types;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import uk.org.ogsadai.common.BinaryLob;
import uk.org.ogsadai.common.CharacterLob;
import uk.org.ogsadai.converters.webrowset.resultset.types.TypeStrategy;

public class VarCharStrategy
extends TypeStrategy {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2002 - 2005.";

    public String getString(String string) {
        return string;
    }

    public InputStream getAsciiStream(String string) {
        if (string == null) {
            return null;
        }
        return new ByteArrayInputStream(string.getBytes());
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Cannot convert " + string + " to BigDecimal");
        }
    }

    public InputStream getBinaryStream(String string) {
        if (string == null) {
            return null;
        }
        return new ByteArrayInputStream(string.getBytes());
    }

    public BigInteger getBigInteger(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            return new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Cannot convert " + string + " to BigInteger");
        }
    }

    public Blob getBlob(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        BinaryLob binaryLob = new BinaryLob();
        binaryLob.setBytes(1L, string.getBytes());
        return binaryLob;
    }

    public boolean getBoolean(String string) throws SQLException {
        if (string == null) {
            return false;
        }
        return new Boolean(string);
    }

    public byte[] getBytes(String string) {
        if (string == null) {
            return null;
        }
        return string.getBytes();
    }

    public Reader getCharacterStream(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        return new StringReader(string);
    }

    public Clob getClob(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        CharacterLob characterLob = new CharacterLob();
        characterLob.setString(1L, string);
        return characterLob;
    }

    public Object getObject(String string) {
        return this.getString(string);
    }
}

