/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset.resultset.types;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import uk.org.ogsadai.converters.webrowset.resultset.types.ArrayStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.BigIntStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.BlobStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.BooleanStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.ClobStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.DateStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.DecimalStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.DoubleStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.FloatStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.IntegerStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.NumericStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.SmallIntStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.TimeStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.TimestampStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.TinyIntStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.TypeStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.UnknownColumnStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.VarCharStrategy;

public class TypeStrategyFactory {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2002 - 2005.";

    public static TypeStrategy createTypeStrategy(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        int n2 = resultSetMetaData.getColumnType(n);
        TypeStrategy typeStrategy = null;
        switch (n2) {
            case 2003: {
                typeStrategy = new ArrayStrategy();
                break;
            }
            case -7: 
            case 16: {
                typeStrategy = new BooleanStrategy();
                break;
            }
            case -6: {
                typeStrategy = new TinyIntStrategy();
                break;
            }
            case 5: {
                typeStrategy = new SmallIntStrategy();
                break;
            }
            case -5: {
                typeStrategy = new BigIntStrategy();
                break;
            }
            case 4: {
                typeStrategy = new IntegerStrategy();
                break;
            }
            case 3: {
                typeStrategy = new DecimalStrategy();
                break;
            }
            case 6: 
            case 7: {
                typeStrategy = new FloatStrategy();
                break;
            }
            case 8: {
                typeStrategy = new DoubleStrategy();
                break;
            }
            case 2: {
                int n3 = resultSetMetaData.getScale(n);
                typeStrategy = new NumericStrategy(n3);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                typeStrategy = new VarCharStrategy();
                break;
            }
            case 93: {
                typeStrategy = new TimestampStrategy();
                break;
            }
            case 92: {
                typeStrategy = new TimeStrategy();
                break;
            }
            case 91: {
                typeStrategy = new DateStrategy();
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                typeStrategy = new BlobStrategy();
                break;
            }
            case 2005: {
                typeStrategy = new ClobStrategy();
                break;
            }
            default: {
                typeStrategy = new UnknownColumnStrategy();
            }
        }
        return typeStrategy;
    }
}

