/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset.resultset.types;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import uk.org.ogsadai.converters.webrowset.resultset.types.TypeStrategy;

public class TimestampStrategy
extends TypeStrategy {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2002 - 2005.";
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat();
    private static final String[] FORMATS = new String[]{"yyyy-MM-dd HH:mm:ss.sssZ", "yyyy-MM-dd HH:mm:ssZ"};

    public String getString(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        return this.getTimestamp(string).toString();
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            return Timestamp.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (int i = 0; i < FORMATS.length; ++i) {
                try {
                    FORMATTER.applyPattern(FORMATS[i]);
                    return new Timestamp(FORMATTER.parse(string).getTime());
                }
                catch (ParseException parseException) {
                    continue;
                }
            }
            try {
                return new Timestamp(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Cannot convert " + string + " to java.sql.Timestamp");
            }
        }
    }

    public Date getDate(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        long l = this.getTimestamp(string).getTime();
        return new Date(l);
    }

    public Time getTime(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        long l = this.getTimestamp(string).getTime();
        return new Time(l);
    }

    public Object getObject(String string) throws SQLException {
        return this.getTimestamp(string);
    }
}

