/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset.resultset.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import uk.org.ogsadai.converters.webrowset.resultset.types.TypeStrategy;

public class NumberStrategy
extends TypeStrategy {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2002 - 2005.";

    public boolean getBoolean(String string) throws SQLException {
        boolean bl = false;
        if (string != null) {
            try {
                bl = Double.parseDouble(string) != 0.0;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Cannot convert " + string + " to double");
            }
        }
        return bl;
    }

    public byte getByte(String string) throws SQLException {
        byte by = 0;
        if (string != null) {
            try {
                by = Byte.parseByte(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Cannot convert " + string + " to double");
            }
        }
        return by;
    }

    public short getShort(String string) throws SQLException {
        short s = 0;
        if (string != null) {
            try {
                s = Short.parseShort(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Cannot convert " + string + " to short");
            }
        }
        return s;
    }

    public int getInt(String string) throws SQLException {
        int n = 0;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Cannot convert " + string + " to int");
            }
        }
        return n;
    }

    public long getLong(String string) throws SQLException {
        long l = 0L;
        if (string != null) {
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Cannot convert " + string + " to long");
            }
        }
        return l;
    }

    public double getDouble(String string) throws SQLException {
        double d = 0.0;
        if (string != null) {
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Cannot convert " + string + " to double");
            }
        }
        return d;
    }

    public float getFloat(String string) throws SQLException {
        float f = 0.0f;
        if (string != null) {
            try {
                f = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Cannot convert " + string + " to float");
            }
        }
        return f;
    }

    public String getString(String string) throws SQLException {
        return string;
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            return bigDecimal;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Cannot convert " + string + " to BigDecimal");
        }
    }

    public BigInteger getBigInteger(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            BigInteger bigInteger = new BigInteger(string);
            return bigInteger;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Cannot convert " + string + " to BigInteger");
        }
    }
}

