/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset.resultset;

import java.io.IOException;
import java.io.Reader;
import java.sql.ResultSet;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.org.ogsadai.common.xml.XMLDocumentException;
import uk.org.ogsadai.common.xml.XMLParseException;
import uk.org.ogsadai.converters.webrowset.SAXWrappedException;
import uk.org.ogsadai.converters.webrowset.SQLWrappedException;
import uk.org.ogsadai.converters.webrowset.WebRowSetParser;
import uk.org.ogsadai.converters.webrowset.WebRowSetResultSetParseException;
import uk.org.ogsadai.converters.webrowset.resultset.ResultSetForwardOnly;
import uk.org.ogsadai.converters.webrowset.resultset.ResultSetScrollable;
import uk.org.ogsadai.exception.DAIIOException;

public class WebRowSetToResultSet {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2002 - 2007.";
    private int mType = 1003;
    private Reader mInput;

    public WebRowSetToResultSet(Reader reader) {
        this.mInput = reader;
    }

    public void setResultSetType(int n) throws IllegalArgumentException {
        if (n != 1004 && n != 1003) {
            throw new IllegalArgumentException("type must be one of ResultSet.TYPE_SCROLL_INSENSITIVE or ResultSet.TYPE_FORWARD_ONLY");
        }
        this.mType = n;
    }

    public ResultSet getResultSet() throws WebRowSetResultSetParseException {
        final WebRowSetParser webRowSetParser = new WebRowSetParser();
        webRowSetParser.setInput(this.mInput);
        if (this.mType == 1004) {
            ResultSetScrollable resultSetScrollable = new ResultSetScrollable();
            webRowSetParser.setOutput(resultSetScrollable);
            try {
                webRowSetParser.parse();
                return resultSetScrollable;
            }
            catch (SAXWrappedException sAXWrappedException) {
                Exception exception = sAXWrappedException.getWrappedException();
                if (exception instanceof SQLWrappedException) {
                    throw new WebRowSetResultSetParseException(((SQLWrappedException)exception).getWrappedException());
                }
                throw new WebRowSetResultSetParseException(exception);
            }
            catch (SAXParseException sAXParseException) {
                throw new WebRowSetResultSetParseException(new XMLDocumentException(sAXParseException));
            }
            catch (SAXException sAXException) {
                throw new WebRowSetResultSetParseException(new XMLParseException(sAXException));
            }
            catch (IOException iOException) {
                throw new WebRowSetResultSetParseException(new DAIIOException(iOException));
            }
        }
        final ResultSetForwardOnly resultSetForwardOnly = new ResultSetForwardOnly();
        webRowSetParser.setOutput(resultSetForwardOnly);
        Thread thread = new Thread(){

            public void run() {
                try {
                    webRowSetParser.parse();
                    resultSetForwardOnly.parserCompleted();
                }
                catch (SAXWrappedException sAXWrappedException) {
                    WebRowSetResultSetParseException webRowSetResultSetParseException = new WebRowSetResultSetParseException(sAXWrappedException.getWrappedException());
                    resultSetForwardOnly.setError(webRowSetResultSetParseException);
                }
                catch (SAXException sAXException) {
                    WebRowSetResultSetParseException webRowSetResultSetParseException = new WebRowSetResultSetParseException(new XMLParseException(sAXException));
                    resultSetForwardOnly.setError(webRowSetResultSetParseException);
                }
                catch (IOException iOException) {
                    WebRowSetResultSetParseException webRowSetResultSetParseException = new WebRowSetResultSetParseException(new DAIIOException(iOException));
                    resultSetForwardOnly.setError(webRowSetResultSetParseException);
                }
                catch (Throwable throwable) {
                    WebRowSetResultSetParseException webRowSetResultSetParseException = new WebRowSetResultSetParseException(throwable);
                    resultSetForwardOnly.setError(webRowSetResultSetParseException);
                }
            }
        };
        thread.start();
        return resultSetForwardOnly;
    }
}

