/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset.resultset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Vector;
import uk.org.ogsadai.converters.webrowset.SQLWrappedException;
import uk.org.ogsadai.converters.webrowset.resultset.AbstractResultSet;

public class ResultSetForwardOnly
extends AbstractResultSet {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2002 - 2007.";
    private int mBufferSize = 100;
    private LinkedList mBuffer = new LinkedList();
    private boolean mClosed = false;
    private Vector mCurrentRow;
    private int mCursor = 0;
    private Throwable mError = null;
    private boolean mIsParserCompleted = false;

    public synchronized void parserCompleted() {
        this.mIsParserCompleted = true;
        this.notifyAll();
    }

    public synchronized void setError(Throwable throwable) {
        this.mError = throwable;
        this.notifyAll();
    }

    public Throwable getError() {
        return this.mError;
    }

    public synchronized void putMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        super.putMetaData(resultSetMetaData);
        this.notifyAll();
    }

    public synchronized void putRow(Vector vector) {
        if (vector == null) {
            this.mClosed = true;
            this.notifyAll();
            return;
        }
        if (this.mBuffer.size() > this.mBufferSize) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.mBuffer.addLast(vector);
        this.notifyAll();
    }

    public synchronized boolean next() throws SQLException {
        while (this.mBuffer.size() == 0 && !this.mClosed && this.mError == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.notifyAll();
        if (this.mBuffer.size() == 0) {
            if (this.mError != null) {
                throw new SQLWrappedException(this.mError);
            }
            if (this.mClosed) {
                while (!this.mIsParserCompleted) {
                    if (this.mError != null) {
                        throw new SQLWrappedException(this.mError);
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return false;
            }
        }
        this.mCurrentRow = (Vector)this.mBuffer.removeFirst();
        ++this.mCursor;
        return true;
    }

    public void setBufferSize(int n) {
        this.mBufferSize = n;
    }

    public int getBufferSize() {
        return this.mBufferSize;
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        while (this.mMetaData == null && this.mError == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.mError != null) {
            throw new SQLWrappedException(this.mError);
        }
        return this.mMetaData;
    }

    protected Vector getCurrentRow() {
        return this.mCurrentRow;
    }

    protected String getColumn(int n) throws SQLException {
        if (this.mCurrentRow == null) {
            throw new SQLException("Illegal operation - no current row.");
        }
        return (String)this.mCurrentRow.get(n - 1);
    }

    public int getRow() throws SQLException {
        return this.mCursor;
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public void afterLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean first() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isAfterLast() throws SQLException {
        return this.mClosed;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.mCursor == 0;
    }

    public boolean isFirst() throws SQLException {
        return this.mCursor == 1;
    }

    public boolean isLast() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean last() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean previous() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean absolute(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean relative(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

