/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset.resultset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import uk.org.ogsadai.converters.webrowset.SQLWrappedException;
import uk.org.ogsadai.converters.webrowset.WebRowSetHandler;
import uk.org.ogsadai.converters.webrowset.resultset.types.TypeStrategy;
import uk.org.ogsadai.converters.webrowset.resultset.types.TypeStrategyFactory;

public abstract class AbstractResultSet
implements ResultSet,
WebRowSetHandler {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2002 - 2005.";
    protected ResultSetMetaData mMetaData;
    private Map mColumnNames = new HashMap();
    private TypeStrategy[] mColStrategy;

    public abstract void putRow(Vector var1);

    public void putMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        this.mMetaData = resultSetMetaData;
        int n = resultSetMetaData.getColumnCount();
        this.mColStrategy = new TypeStrategy[n + 1];
        for (int i = 1; i <= n; ++i) {
            this.mColStrategy[i] = TypeStrategyFactory.createTypeStrategy(resultSetMetaData, i);
            this.mColumnNames.put(resultSetMetaData.getColumnName(i).toUpperCase(), new Integer(i));
        }
    }

    protected abstract String getColumn(int var1) throws SQLException;

    public int findColumn(String string) throws SQLException {
        Integer n = (Integer)this.mColumnNames.get(string.toUpperCase());
        if (n != null) {
            return n;
        }
        throw new SQLWrappedException(new IllegalArgumentException("No such column: " + string));
    }

    public int getConcurrency() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public abstract int getRow() throws SQLException;

    public abstract int getType() throws SQLException;

    public abstract void afterLast() throws SQLException;

    public abstract void beforeFirst() throws SQLException;

    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void close() throws SQLException {
    }

    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public abstract boolean first() throws SQLException;

    public abstract boolean isAfterLast() throws SQLException;

    public abstract boolean isBeforeFirst() throws SQLException;

    public abstract boolean isFirst() throws SQLException;

    public abstract boolean isLast() throws SQLException;

    public abstract boolean last() throws SQLException;

    public abstract boolean next() throws SQLException;

    public abstract boolean previous() throws SQLException;

    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean wasNull() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public byte getByte(int n) throws SQLException {
        return this.mColStrategy[n].getByte(this.getColumn(n));
    }

    public double getDouble(int n) throws SQLException {
        return this.mColStrategy[n].getDouble(this.getColumn(n));
    }

    public float getFloat(int n) throws SQLException {
        return this.mColStrategy[n].getFloat(this.getColumn(n));
    }

    public int getInt(int n) throws SQLException {
        return this.mColStrategy[n].getInt(this.getColumn(n));
    }

    public long getLong(int n) throws SQLException {
        return this.mColStrategy[n].getLong(this.getColumn(n));
    }

    public short getShort(int n) throws SQLException {
        return this.mColStrategy[n].getShort(this.getColumn(n));
    }

    public void setFetchDirection(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setFetchSize(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateNull(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public abstract boolean absolute(int var1) throws SQLException;

    public abstract boolean relative(int var1) throws SQLException;

    public boolean getBoolean(int n) throws SQLException {
        return this.mColStrategy[n].getBoolean(this.getColumn(n));
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.mColStrategy[n].getBytes(this.getColumn(n));
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateLong(int n, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateShort(int n, short s) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.mColStrategy[n].getAsciiStream(this.getColumn(n));
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this.mColStrategy[n].getBinaryStream(this.getColumn(n));
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.mColStrategy[n].getUnicodeStream(this.getColumn(n));
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return this.mColStrategy[n].getCharacterStream(this.getColumn(n));
    }

    public void updateCharacterStream(int n, Reader reader, int n2) {
        throw new UnsupportedOperationException();
    }

    public Object getObject(int n) throws SQLException {
        return this.mColStrategy[n].getObject(this.getColumn(n));
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getString(int n) throws SQLException {
        return this.mColStrategy[n].getString(this.getColumn(n));
    }

    public void updateString(int n, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public void updateNull(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateDouble(String string, double d) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateInt(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateLong(String string, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateShort(String string, short s) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.mColStrategy[n].getBigDecimal(this.getColumn(n));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.mColStrategy[n].getBigDecimal(this.getColumn(n), n2);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public URL getURL(int n) throws SQLException {
        return this.mColStrategy[n].getURL(this.getColumn(n));
    }

    public Array getArray(int n) throws SQLException {
        return this.mColStrategy[n].getArray(this.getColumn(n));
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(int n) throws SQLException {
        return this.mColStrategy[n].getBlob(this.getColumn(n));
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Clob getClob(int n) throws SQLException {
        return this.mColStrategy[n].getClob(this.getColumn(n));
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(int n) throws SQLException {
        return this.mColStrategy[n].getDate(this.getColumn(n));
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Ref getRef(int n) throws SQLException {
        return this.mColStrategy[n].getRef(this.getColumn(n));
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.mMetaData;
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Statement getStatement() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(int n) throws SQLException {
        return this.mColStrategy[n].getTime(this.getColumn(n));
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.mColStrategy[n].getTimestamp(this.getColumn(n));
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.mColStrategy[n].getObject(this.getColumn(n));
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public void updateString(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.mColStrategy[n].getDate(this.getColumn(n), calendar);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.mColStrategy[n].getTime(this.getColumn(n), calendar);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.mColStrategy[n].getTimestamp(this.getColumn(n), calendar);
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }
}

