/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.webrowset;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import uk.org.ogsadai.converters.webrowset.ElementHandler;
import uk.org.ogsadai.converters.webrowset.SAXWrappedException;
import uk.org.ogsadai.converters.webrowset.WebRowSetHandler;
import uk.org.ogsadai.converters.webrowset.WebRowSetParseException;
import uk.org.ogsadai.converters.webrowset.metadata.ColumnMetaData;
import uk.org.ogsadai.exception.ExternalModuleException;

public class WebRowSetParser
extends DefaultHandler {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2002 - 2007.";
    private SAXParser mParser;
    private InputSource mInput;
    private WebRowSetHandler mOutput;
    private ElementHandler mHandler;
    private Locator mLocator;

    public WebRowSetParser() throws ExternalModuleException {
        try {
            this.mParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ExternalModuleException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new ExternalModuleException(sAXException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new ExternalModuleException(factoryConfigurationError);
        }
    }

    public void setInput(Reader reader) {
        this.mInput = new InputSource(reader);
    }

    public void setOutput(WebRowSetHandler webRowSetHandler) {
        this.mOutput = webRowSetHandler;
    }

    public void setParsingStrategy(ElementHandler elementHandler) {
        this.mHandler = elementHandler;
    }

    public void parse() throws SAXException, IOException {
        this.mHandler = new PropertiesHandler();
        this.mParser.parse(this.mInput, (DefaultHandler)this);
    }

    public void setDocumentLocator(Locator locator) {
        this.mLocator = locator;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.mHandler.startElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.mHandler.endElement(string, string2, string3);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.mHandler.characters(cArray, n, n2);
    }

    private class DataHandler
    implements ElementHandler {
        private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2002 - 2007.";
        private StringBuffer mColumnString = null;
        private Vector mRow;

        private DataHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("columnValue")) {
                this.mColumnString = new StringBuffer();
            } else if (string3.equals("currentRow")) {
                this.mRow = new Vector();
            } else if (string3.equals("data")) {
                // empty if block
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("columnValue")) {
                if (this.mRow == null) {
                    IllegalStateException illegalStateException = new IllegalStateException("No current row");
                    throw new SAXParseException(illegalStateException.getLocalizedMessage(), WebRowSetParser.this.mLocator, illegalStateException);
                }
                if (this.mColumnString != null) {
                    this.mRow.add(this.mColumnString.toString());
                } else {
                    this.mRow.add(null);
                }
                this.mColumnString = null;
            } else if (string3.equals("null")) {
                this.mColumnString = null;
            } else {
                if (string3.equals("currentRow")) {
                    try {
                        WebRowSetParser.this.mOutput.putRow(this.mRow);
                    }
                    catch (Exception exception) {
                        throw new SAXWrappedException(exception);
                    }
                }
                if (string3.equals("webRowSet")) {
                    try {
                        WebRowSetParser.this.mOutput.putRow(null);
                    }
                    catch (Exception exception) {
                        throw new SAXWrappedException(exception);
                    }
                }
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            if (this.mColumnString != null) {
                this.mColumnString.append(cArray, n, n2);
            }
        }
    }

    private class MetaDataHandler
    implements ElementHandler {
        private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2002 - 2005.";
        private ColumnMetaData mMetaData = new ColumnMetaData();
        private StringBuffer mValue;
        private int mCurrentColumn;
        private final int META_DATA = 1;
        private final int COLUMN_COUNT = 2;
        private int mExpected = 1;

        private MetaDataHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.mExpected > 0) {
                if (this.mExpected == 1) {
                    if (!string3.equals("metadata")) {
                        WebRowSetParseException webRowSetParseException = new WebRowSetParseException(string3);
                        throw new SAXParseException(webRowSetParseException.getLocalizedMessage(), WebRowSetParser.this.mLocator, webRowSetParseException);
                    }
                    this.mExpected = 2;
                } else if (this.mExpected == 2) {
                    if (!string3.equals("column-count")) {
                        WebRowSetParseException webRowSetParseException = new WebRowSetParseException(string3);
                        throw new SAXParseException(webRowSetParseException.getLocalizedMessage(), WebRowSetParser.this.mLocator, webRowSetParseException);
                    }
                    this.mExpected = 0;
                    this.mValue = new StringBuffer();
                }
            } else {
                this.mValue = new StringBuffer();
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("metadata")) {
                WebRowSetParser.this.mHandler = new DataHandler();
                try {
                    WebRowSetParser.this.mOutput.putMetaData(this.mMetaData);
                }
                catch (Exception exception) {
                    throw new SAXWrappedException(exception);
                }
            } else if (string3.equals("column-index")) {
                this.mCurrentColumn = Integer.parseInt(this.mValue.toString());
            } else if (string3.equals("column-definition")) {
                this.mCurrentColumn = 0;
            } else if (string3.equals("column-count")) {
                this.mMetaData.setColumnCount(Integer.parseInt(this.mValue.toString()));
            } else {
                this.mMetaData.storeData(this.mCurrentColumn, string3, this.mValue.toString());
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            if (this.mValue != null) {
                this.mValue.append(cArray, n, n2);
            }
        }
    }

    private class PropertiesHandler
    implements ElementHandler {
        private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2002 - 2007.";
        private String mExpected = "webRowSet";

        private PropertiesHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.mExpected != null && !string3.equals(this.mExpected)) {
                WebRowSetParseException webRowSetParseException = new WebRowSetParseException(string3);
                throw new SAXParseException(webRowSetParseException.getLocalizedMessage(), WebRowSetParser.this.mLocator, webRowSetParseException);
            }
            this.mExpected = string3.equals("webRowSet") ? "properties" : null;
        }

        public void endElement(String string, String string2, String string3) {
            if (string3.equals("properties")) {
                WebRowSetParser.this.mHandler = new MetaDataHandler();
            }
        }

        public void characters(char[] cArray, int n, int n2) {
        }
    }
}

