/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.resultset.webrowset;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import uk.org.ogsadai.converters.resultset.ResultSetHandler;
import uk.org.ogsadai.converters.resultset.ResultSetHandlerException;
import uk.org.ogsadai.converters.resultset.StrategicResultSetHandler;
import uk.org.ogsadai.converters.resultset.webrowset.WebRowSetColumnStrategyFactory;

public class WebRowSetResultSetHandler
extends StrategicResultSetHandler
implements ResultSetHandler {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2002 - 2007.";
    private final String ROWSTART_TAG = "<currentRow>\n";
    private final String ROWEND_TAG = "</currentRow>";
    private final String COLSTART_TAG = "<columnValue>";
    private final String COLEND_TAG = "</columnValue>\n";

    public WebRowSetResultSetHandler(ResultSet resultSet) throws ResultSetHandlerException {
        super(resultSet, new WebRowSetColumnStrategyFactory());
    }

    public void header(StringBuffer stringBuffer, ResultSet resultSet) throws ResultSetHandlerException {
        try {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("<webRowSet ");
            stringBuffer2.append("xmlns=\"http://java.sun.com/xml/ns/jdbc\" ");
            stringBuffer2.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            stringBuffer2.append("xsi:schemaLocation=\"http://java.sun.com/xml/ns/jdbc ");
            stringBuffer2.append("http://java.sun.com/xml/ns/jdbc/webrowset.xsd\">\n");
            stringBuffer2.append(this.properties(resultSet));
            stringBuffer2.append(this.metadata(resultSet.getMetaData()));
            stringBuffer2.append("\n<data>");
            stringBuffer.append(stringBuffer2);
        }
        catch (Exception exception) {
            throw new ResultSetHandlerException(exception);
        }
    }

    public void rowStart(StringBuffer stringBuffer) {
        stringBuffer.append("<currentRow>\n");
    }

    public void columnStart(StringBuffer stringBuffer) {
        stringBuffer.append("<columnValue>");
    }

    public void columnEnd(StringBuffer stringBuffer) {
        stringBuffer.append("</columnValue>\n");
    }

    public void rowEnd(StringBuffer stringBuffer) {
        stringBuffer.append("</currentRow>");
    }

    public void footer(StringBuffer stringBuffer) {
        stringBuffer.append("</data>\n</webRowSet>");
    }

    private String properties(ResultSet resultSet) throws ResultSetHandlerException {
        try {
            int n;
            String string;
            StringBuffer stringBuffer = new StringBuffer("<properties>\n");
            stringBuffer.append("<command></command>\n");
            stringBuffer.append("<concurrency>");
            stringBuffer.append(resultSet.getConcurrency());
            stringBuffer.append("</concurrency>\n");
            stringBuffer.append("<datasource></datasource>\n");
            stringBuffer.append("<escape-processing>true</escape-processing>\n");
            try {
                string = String.valueOf(resultSet.getFetchDirection());
            }
            catch (Exception exception) {
                string = "";
            }
            stringBuffer.append("<fetch-direction>");
            stringBuffer.append(string);
            stringBuffer.append("</fetch-direction>\n");
            try {
                string = String.valueOf(resultSet.getFetchSize());
            }
            catch (Exception exception) {
                string = "";
            }
            stringBuffer.append("<fetch-size>");
            stringBuffer.append(string);
            stringBuffer.append("</fetch-size>\n");
            stringBuffer.append("<isolation-level>0</isolation-level>\n");
            stringBuffer.append("<key-columns></key-columns>\n");
            stringBuffer.append("<map></map>\n");
            Statement statement = resultSet.getStatement();
            try {
                string = String.valueOf(statement.getMaxFieldSize());
            }
            catch (Exception exception) {
                string = "";
            }
            stringBuffer.append("<max-field-size>");
            stringBuffer.append(string);
            stringBuffer.append("</max-field-size>\n");
            try {
                string = String.valueOf(statement.getMaxRows());
            }
            catch (Exception exception) {
                string = "";
            }
            stringBuffer.append("<max-rows>");
            stringBuffer.append(string);
            stringBuffer.append("</max-rows>\n");
            try {
                string = String.valueOf(statement.getQueryTimeout());
            }
            catch (Exception exception) {
                string = "";
            }
            stringBuffer.append("<query-timeout>");
            stringBuffer.append(string);
            stringBuffer.append("</query-timeout>\n");
            stringBuffer.append("<read-only>true</read-only>\n");
            try {
                n = resultSet.getType();
            }
            catch (Exception exception) {
                n = -1;
            }
            String string2 = "";
            switch (n) {
                case 1003: {
                    string2 = "ResultSet.TYPE_FORWARD_ONLY";
                    break;
                }
                case 1004: {
                    string2 = "ResultSet.TYPE_SCROLL_INSENSITIVE";
                    break;
                }
                case 1005: {
                    string2 = "ResultSet.TYPE_SCROLL_SENSITIVE";
                }
            }
            stringBuffer.append("<rowset-type>");
            stringBuffer.append(string2);
            stringBuffer.append("</rowset-type>\n");
            stringBuffer.append("<show-deleted>false</show-deleted>\n");
            stringBuffer.append("<table-name></table-name>\n");
            stringBuffer.append("<url></url>\n");
            stringBuffer.append("<sync-provider>\n");
            stringBuffer.append("<sync-provider-name/>\n");
            stringBuffer.append("<sync-provider-vendor/>\n");
            stringBuffer.append("<sync-provider-version/>\n");
            stringBuffer.append("<sync-provider-grade/>\n");
            stringBuffer.append("<data-source-lock/>\n");
            stringBuffer.append("</sync-provider>\n");
            stringBuffer.append("</properties>\n");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            throw new ResultSetHandlerException(exception);
        }
    }

    private String metadata(ResultSetMetaData resultSetMetaData) throws ResultSetHandlerException {
        try {
            StringBuffer stringBuffer = new StringBuffer("<metadata>\n");
            int n = resultSetMetaData.getColumnCount();
            stringBuffer.append("<column-count>" + Integer.toString(n) + "</column-count>\n");
            for (int i = 1; i <= n; ++i) {
                stringBuffer.append("<column-definition>\n");
                stringBuffer.append("<column-index>");
                stringBuffer.append(i);
                stringBuffer.append("</column-index>\n");
                stringBuffer.append("<auto-increment>");
                stringBuffer.append(resultSetMetaData.isAutoIncrement(i));
                stringBuffer.append("</auto-increment>\n");
                stringBuffer.append("<case-sensitive>");
                stringBuffer.append(resultSetMetaData.isCaseSensitive(i));
                stringBuffer.append("</case-sensitive>\n");
                stringBuffer.append("<currency>");
                stringBuffer.append(resultSetMetaData.isCurrency(i));
                stringBuffer.append("</currency>\n");
                stringBuffer.append("<nullable>");
                stringBuffer.append(resultSetMetaData.isNullable(i));
                stringBuffer.append("</nullable>\n");
                stringBuffer.append("<signed>");
                stringBuffer.append(resultSetMetaData.isSigned(i));
                stringBuffer.append("</signed>\n");
                stringBuffer.append("<searchable>");
                stringBuffer.append(resultSetMetaData.isSearchable(i));
                stringBuffer.append("</searchable>\n");
                stringBuffer.append("<column-display-size>");
                stringBuffer.append(resultSetMetaData.getColumnDisplaySize(i));
                stringBuffer.append("</column-display-size>\n");
                stringBuffer.append("<column-label>");
                stringBuffer.append(resultSetMetaData.getColumnLabel(i));
                stringBuffer.append("</column-label>\n");
                stringBuffer.append("<column-name>");
                stringBuffer.append(resultSetMetaData.getColumnName(i));
                stringBuffer.append("</column-name>\n");
                stringBuffer.append("<schema-name>");
                stringBuffer.append(resultSetMetaData.getSchemaName(i));
                stringBuffer.append("</schema-name>\n");
                stringBuffer.append("<column-precision>");
                if (resultSetMetaData.getColumnType(i) == 2004) {
                    stringBuffer.append("0");
                } else {
                    stringBuffer.append(resultSetMetaData.getPrecision(i));
                }
                stringBuffer.append("</column-precision>\n");
                stringBuffer.append("<column-scale>");
                stringBuffer.append(resultSetMetaData.getScale(i));
                stringBuffer.append("</column-scale>\n");
                stringBuffer.append("<table-name>");
                stringBuffer.append(resultSetMetaData.getTableName(i));
                stringBuffer.append("</table-name>\n");
                stringBuffer.append("<catalog-name>");
                stringBuffer.append(resultSetMetaData.getCatalogName(i));
                stringBuffer.append("</catalog-name>\n");
                stringBuffer.append("<column-type>");
                stringBuffer.append(resultSetMetaData.getColumnType(i));
                stringBuffer.append("</column-type>\n");
                stringBuffer.append("<column-type-name>");
                stringBuffer.append(resultSetMetaData.getColumnTypeName(i));
                stringBuffer.append("</column-type-name>\n");
                stringBuffer.append("</column-definition>\n");
            }
            stringBuffer.append("</metadata>");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            throw new ResultSetHandlerException(exception);
        }
    }
}

