/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.resultset;

import java.sql.ResultSet;
import java.sql.SQLException;
import uk.org.ogsadai.converters.resultset.ColumnStrategy;
import uk.org.ogsadai.converters.resultset.ColumnStrategyFactory;
import uk.org.ogsadai.converters.resultset.ResultSetHandler;
import uk.org.ogsadai.converters.resultset.ResultSetHandlerColumnException;
import uk.org.ogsadai.converters.resultset.ResultSetHandlerException;

public abstract class StrategicResultSetHandler
implements ResultSetHandler {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2002 - 2007.";
    private final ColumnStrategy[] mStrategies;

    public StrategicResultSetHandler(ResultSet resultSet, ColumnStrategyFactory columnStrategyFactory) throws ResultSetHandlerException {
        try {
            this.mStrategies = new ColumnStrategy[resultSet.getMetaData().getColumnCount()];
            for (int i = 0; i < this.mStrategies.length; ++i) {
                int n = resultSet.getMetaData().getColumnType(i + 1);
                this.mStrategies[i] = columnStrategyFactory.createColumnStrategy(n);
            }
        }
        catch (SQLException sQLException) {
            throw new ResultSetHandlerException(sQLException);
        }
    }

    public final void field(StringBuffer stringBuffer, ResultSet resultSet, int n) throws ResultSetHandlerException {
        try {
            this.mStrategies[n - 1].convertField(stringBuffer, resultSet, n);
        }
        catch (Exception exception) {
            throw new ResultSetHandlerException(new ResultSetHandlerColumnException(n, (Throwable)exception));
        }
    }
}

