/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.resultset;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import uk.org.ogsadai.converters.resultset.ResultSetHandler;
import uk.org.ogsadai.converters.resultset.ResultSetHandlerException;

public class ResultSetConverter {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2002 - 2007.";
    private final ResultSet mResultSet;
    private final ResultSetHandler mHandler;
    private StringBuffer mBlock;
    private boolean mHeader = true;
    private boolean mFooter = true;

    public ResultSetConverter(ResultSet resultSet, ResultSetHandler resultSetHandler) {
        if (resultSet == null) {
            throw new IllegalArgumentException("results must not be null");
        }
        if (resultSetHandler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        this.mResultSet = resultSet;
        this.mHandler = resultSetHandler;
    }

    public boolean hasNext() throws ResultSetHandlerException {
        if (this.mHeader) {
            this.processNextBlock();
        }
        return this.mBlock != null;
    }

    public String next() throws ResultSetHandlerException {
        if (this.hasNext()) {
            StringBuffer stringBuffer = this.mBlock;
            this.processNextBlock();
            return stringBuffer.toString();
        }
        throw new NoSuchElementException();
    }

    private void processNextBlock() throws ResultSetHandlerException {
        StringBuffer stringBuffer = this.createStringBuffer();
        try {
            if (this.mHeader) {
                this.mHeader = false;
                this.mHandler.header(stringBuffer, this.mResultSet);
                this.mBlock = stringBuffer;
            } else if (this.mFooter && this.mResultSet.next()) {
                this.processRow(stringBuffer);
                this.mBlock = stringBuffer;
            } else if (this.mFooter) {
                this.mFooter = false;
                this.mHandler.footer(stringBuffer);
                this.mBlock = stringBuffer;
            } else {
                this.mBlock = null;
            }
        }
        catch (SQLException sQLException) {
            throw new ResultSetHandlerException(sQLException);
        }
    }

    private void processRow(StringBuffer stringBuffer) throws ResultSetHandlerException {
        try {
            this.mHandler.rowStart(stringBuffer);
            int n = this.mResultSet.getMetaData().getColumnCount();
            for (int i = 1; i <= n; ++i) {
                this.mHandler.columnStart(stringBuffer);
                this.mHandler.field(stringBuffer, this.mResultSet, i);
                this.mHandler.columnEnd(stringBuffer);
            }
            this.mHandler.rowEnd(stringBuffer);
        }
        catch (SQLException sQLException) {
            throw new ResultSetHandlerException(sQLException);
        }
    }

    protected StringBuffer createStringBuffer() {
        return new StringBuffer();
    }
}

