/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.databaseschema.toxml;

import uk.org.ogsadai.converters.databaseschema.ColumnMetaData;
import uk.org.ogsadai.converters.databaseschema.KeyMetaData;
import uk.org.ogsadai.converters.databaseschema.TableMetaData;
import uk.org.ogsadai.converters.databaseschema.toxml.SchemaToCharArraysConverter;

public class SchemaToCharArraysConverterImpl
implements SchemaToCharArraysConverter {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2002 - 2007.";

    public char[] write(TableMetaData tableMetaData) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.writeHeader());
        stringBuffer.append(this.writeTable(tableMetaData));
        stringBuffer.append(this.writeFooter());
        return stringBuffer.toString().toCharArray();
    }

    private char[] writeHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append("databaseSchema");
        stringBuffer.append(" xmlns=\"");
        stringBuffer.append("http://ogsadai.org.uk/namespaces/2005/10/properties");
        stringBuffer.append("\">\n");
        stringBuffer.append("<");
        stringBuffer.append("logicalSchema");
        stringBuffer.append(">\n");
        char[] cArray = new char[stringBuffer.length()];
        stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
        return cArray;
    }

    private char[] writeFooter() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("</");
        stringBuffer.append("logicalSchema");
        stringBuffer.append(">\n");
        stringBuffer.append("</");
        stringBuffer.append("databaseSchema");
        stringBuffer.append(">\n");
        char[] cArray = new char[stringBuffer.length()];
        stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
        return cArray;
    }

    private char[] writeTable(TableMetaData tableMetaData) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append("table");
        stringBuffer.append(" ");
        stringBuffer.append("name");
        stringBuffer.append("=\"");
        stringBuffer.append(tableMetaData.getName());
        stringBuffer.append("\" ");
        stringBuffer.append("schema");
        stringBuffer.append("=\"");
        stringBuffer.append(tableMetaData.getSchemaName());
        stringBuffer.append("\" ");
        stringBuffer.append("catalog");
        stringBuffer.append("=\"");
        stringBuffer.append(tableMetaData.getCatalogName());
        stringBuffer.append("\">\n");
        this.addColumns(tableMetaData, stringBuffer);
        this.addPrimaryKeys(tableMetaData.getPrimaryKeys(), stringBuffer);
        this.addImportedKeys(tableMetaData.getImportedKeys(), stringBuffer);
        this.addExportedKeys(tableMetaData.getExportedKeys(), stringBuffer);
        stringBuffer.append("</table>\n");
        char[] cArray = new char[stringBuffer.length()];
        stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
        return cArray;
    }

    private void addColumns(TableMetaData tableMetaData, StringBuffer stringBuffer) {
        int n = tableMetaData.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            ColumnMetaData columnMetaData = tableMetaData.getColumn(i);
            stringBuffer.append("<");
            stringBuffer.append("column");
            stringBuffer.append(" ");
            stringBuffer.append("name");
            stringBuffer.append("=\"");
            stringBuffer.append(columnMetaData.getName());
            stringBuffer.append("\" ");
            stringBuffer.append("fullName");
            stringBuffer.append("=\"");
            stringBuffer.append(columnMetaData.getTable().getName() + "_" + columnMetaData.getName());
            stringBuffer.append("\" ");
            stringBuffer.append("length");
            stringBuffer.append("=\"");
            stringBuffer.append(columnMetaData.getColumnSize());
            stringBuffer.append("\" ");
            stringBuffer.append("nullable");
            stringBuffer.append("=\"");
            stringBuffer.append(columnMetaData.isNullable());
            stringBuffer.append("\" ");
            stringBuffer.append("default");
            stringBuffer.append("=\"");
            stringBuffer.append(columnMetaData.getDefaultValue());
            stringBuffer.append("\" ");
            stringBuffer.append("position");
            stringBuffer.append("=\"");
            stringBuffer.append(columnMetaData.getPosition());
            stringBuffer.append("\">");
            stringBuffer.append("<");
            stringBuffer.append("sqlTypeName");
            stringBuffer.append(">");
            stringBuffer.append(columnMetaData.getSQLType());
            stringBuffer.append("</");
            stringBuffer.append("sqlTypeName");
            stringBuffer.append(">");
            stringBuffer.append("<");
            stringBuffer.append("sqlJavaTypeID");
            stringBuffer.append(">");
            stringBuffer.append(columnMetaData.getDataType());
            stringBuffer.append("</");
            stringBuffer.append("sqlJavaTypeID");
            stringBuffer.append(">");
            stringBuffer.append("</");
            stringBuffer.append("column");
            stringBuffer.append(">\n");
        }
    }

    private void addPrimaryKeys(String[] stringArray, StringBuffer stringBuffer) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        stringBuffer.append("<");
        stringBuffer.append("primaryKey");
        stringBuffer.append(">\n");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("<");
            stringBuffer.append("columnName");
            stringBuffer.append(">");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("</");
            stringBuffer.append("columnName");
            stringBuffer.append(">\n");
        }
        stringBuffer.append("</");
        stringBuffer.append("primaryKey");
        stringBuffer.append(">\n");
    }

    private void addImportedKeys(KeyMetaData[] keyMetaDataArray, StringBuffer stringBuffer) {
        if (keyMetaDataArray == null) {
            return;
        }
        for (int i = 0; i < keyMetaDataArray.length; ++i) {
            stringBuffer.append("<");
            stringBuffer.append("importedKey");
            stringBuffer.append(" ");
            stringBuffer.append("FKTableName");
            stringBuffer.append("=\"");
            stringBuffer.append(keyMetaDataArray[i].getForeignTableName());
            stringBuffer.append("\" ");
            stringBuffer.append("FKColumnName");
            stringBuffer.append("=\"");
            stringBuffer.append(keyMetaDataArray[i].getForeignColumnName());
            stringBuffer.append("\" ");
            stringBuffer.append("PKTableName");
            stringBuffer.append("=\"");
            stringBuffer.append(keyMetaDataArray[i].getPrimaryKeyTableName());
            stringBuffer.append("\" ");
            stringBuffer.append("PKColumnName");
            stringBuffer.append("=\"");
            stringBuffer.append(keyMetaDataArray[i].getPrimaryKeyColumnName());
            stringBuffer.append("\"/>\n");
        }
    }

    private void addExportedKeys(KeyMetaData[] keyMetaDataArray, StringBuffer stringBuffer) {
        if (keyMetaDataArray == null) {
            return;
        }
        for (int i = 0; i < keyMetaDataArray.length; ++i) {
            stringBuffer.append("<");
            stringBuffer.append("exportedKey");
            stringBuffer.append(" ");
            stringBuffer.append("FKTableName");
            stringBuffer.append("=\"");
            stringBuffer.append(keyMetaDataArray[i].getForeignTableName());
            stringBuffer.append("\" ");
            stringBuffer.append("FKColumnName");
            stringBuffer.append("=\"");
            stringBuffer.append(keyMetaDataArray[i].getForeignColumnName());
            stringBuffer.append("\" ");
            stringBuffer.append("PKTableName");
            stringBuffer.append("=\"");
            stringBuffer.append(keyMetaDataArray[i].getPrimaryKeyTableName());
            stringBuffer.append("\" ");
            stringBuffer.append("PKColumnName");
            stringBuffer.append("=\"");
            stringBuffer.append(keyMetaDataArray[i].getPrimaryKeyColumnName());
            stringBuffer.append("\"/>\n");
        }
    }
}

