/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.databaseschema.fromxml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.org.ogsadai.converters.databaseschema.ColumnMetaData;
import uk.org.ogsadai.converters.databaseschema.ColumnMetaDataImpl;
import uk.org.ogsadai.converters.databaseschema.KeyMetaData;
import uk.org.ogsadai.converters.databaseschema.KeyMetaDataImpl;
import uk.org.ogsadai.converters.databaseschema.RelationalSchemaParseException;
import uk.org.ogsadai.converters.databaseschema.TableMetaData;
import uk.org.ogsadai.converters.databaseschema.TableMetaDataImpl;
import uk.org.ogsadai.converters.databaseschema.fromxml.XMLToSchemaConverter;

public class XMLToSchemaConverterImpl
implements XMLToSchemaConverter {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    private static Pattern[] headerPatterns = new Pattern[]{Pattern.compile("<databaseSchema xmlns=\"http://ogsadai.org.uk/namespaces/2005/10/properties\">"), Pattern.compile("<logicalSchema>")};
    private static Pattern[] tablePatterns = new Pattern[]{Pattern.compile("<table name=\"(.*)\" schema=\"(.*)\" catalog=\"(.*)\">"), Pattern.compile("</table>")};
    private static Pattern[] columnPatterns = new Pattern[]{Pattern.compile("<column name=\"(.*)\" fullName=\"(.*)\" length=\"(.*)\" nullable=\"(.*)\" default=\"(.*)\" position=\"(.*)\"><sqlTypeName>(.*)</sqlTypeName><sqlJavaTypeID>(.*)</sqlJavaTypeID></column>")};
    private static Pattern[] primaryKeysPatterns = new Pattern[]{Pattern.compile("<primaryKey>"), Pattern.compile("<columnName>(.*)</columnName>"), Pattern.compile("</primaryKey>")};
    private static Pattern importedKeysPattern = Pattern.compile("<importedKey FKTableName=\"(.*)\" FKColumnName=\"(.*)\" PKTableName=\"(.*)\" PKColumnName=\"(.*)\"/>");
    private static Pattern exportedKeysPattern = Pattern.compile("<exportedKey FKTableName=\"(.*)\" FKColumnName=\"(.*)\" PKTableName=\"(.*)\" PKColumnName=\"(.*)\"/>");
    private static Pattern[] footerPatterns = new Pattern[]{Pattern.compile("</logicalSchema>"), Pattern.compile("</databaseSchema>")};

    public TableMetaData read(Reader reader) throws RelationalSchemaParseException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        this.readHeader(bufferedReader);
        TableMetaData tableMetaData = this.readTable(bufferedReader);
        this.readFooter(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tableMetaData;
    }

    private void readHeader(BufferedReader bufferedReader) throws RelationalSchemaParseException {
        try {
            String string = bufferedReader.readLine();
            if (!headerPatterns[0].matcher(string).matches()) {
                throw new RelationalSchemaParseException(headerPatterns[0].toString());
            }
            string = bufferedReader.readLine();
            if (!headerPatterns[1].matcher(string).matches()) {
                throw new RelationalSchemaParseException(headerPatterns[1].toString());
            }
        }
        catch (IOException iOException) {
            throw new RelationalSchemaParseException(iOException.getMessage());
        }
    }

    private void readFooter(BufferedReader bufferedReader) throws RelationalSchemaParseException {
        try {
            String string = bufferedReader.readLine();
            if (!footerPatterns[0].matcher(string).matches()) {
                throw new RelationalSchemaParseException(footerPatterns[0].toString());
            }
            string = bufferedReader.readLine();
            if (!footerPatterns[1].matcher(string).matches()) {
                throw new RelationalSchemaParseException(footerPatterns[1].toString());
            }
        }
        catch (IOException iOException) {
            throw new RelationalSchemaParseException(iOException.getMessage());
        }
    }

    private TableMetaData readTable(BufferedReader bufferedReader) throws RelationalSchemaParseException {
        try {
            Object object;
            String string = bufferedReader.readLine();
            Matcher matcher = tablePatterns[0].matcher(string);
            if (!matcher.matches()) {
                throw new RelationalSchemaParseException(string);
            }
            TableMetaDataImpl tableMetaDataImpl = new TableMetaDataImpl(matcher.group(3), matcher.group(2), matcher.group(1));
            ArrayList<Object> arrayList = new ArrayList<Object>();
            string = bufferedReader.readLine();
            matcher = columnPatterns[0].matcher(string);
            while (matcher.matches()) {
                object = new ColumnMetaDataImpl(matcher.group(1), Integer.valueOf(matcher.group(6)), tableMetaDataImpl);
                ((ColumnMetaDataImpl)object).setFullName(matcher.group(2));
                ((ColumnMetaDataImpl)object).setColumnSize(Integer.valueOf(matcher.group(3)));
                ((ColumnMetaDataImpl)object).setTypeName(matcher.group(7));
                ((ColumnMetaDataImpl)object).setDataType(Integer.valueOf(matcher.group(8)));
                ((ColumnMetaDataImpl)object).setNullable(Boolean.valueOf(matcher.group(4)));
                ((ColumnMetaDataImpl)object).setDefaultValue(matcher.group(5));
                arrayList.add(object);
                string = bufferedReader.readLine();
                matcher = columnPatterns[0].matcher(string);
            }
            tableMetaDataImpl.setColumns(arrayList.toArray(new ColumnMetaData[0]));
            matcher = primaryKeysPatterns[0].matcher(string);
            if (matcher.matches()) {
                string = bufferedReader.readLine();
                matcher = primaryKeysPatterns[1].matcher(string);
                while (matcher.matches()) {
                    tableMetaDataImpl.addPrimaryKey(matcher.group(1));
                    string = bufferedReader.readLine();
                    matcher = primaryKeysPatterns[1].matcher(string);
                }
                matcher = primaryKeysPatterns[2].matcher(string);
                if (!matcher.matches()) {
                    throw new RelationalSchemaParseException(primaryKeysPatterns[2].toString());
                }
                string = bufferedReader.readLine();
            }
            matcher = importedKeysPattern.matcher(string);
            while (matcher.matches()) {
                object = new KeyMetaDataImpl();
                ((KeyMetaDataImpl)object).setForeignTable(matcher.group(1));
                ((KeyMetaDataImpl)object).setForeignColumnName(matcher.group(2));
                ((KeyMetaDataImpl)object).setPrimaryKeyTableName(matcher.group(3));
                ((KeyMetaDataImpl)object).setPrimaryKeyColumnName(matcher.group(4));
                tableMetaDataImpl.addImportedKey((KeyMetaData)object);
                string = bufferedReader.readLine();
                matcher = importedKeysPattern.matcher(string);
            }
            matcher = exportedKeysPattern.matcher(string);
            while (matcher.matches()) {
                object = new KeyMetaDataImpl();
                ((KeyMetaDataImpl)object).setForeignTable(matcher.group(1));
                ((KeyMetaDataImpl)object).setForeignColumnName(matcher.group(2));
                ((KeyMetaDataImpl)object).setPrimaryKeyTableName(matcher.group(3));
                ((KeyMetaDataImpl)object).setPrimaryKeyColumnName(matcher.group(4));
                tableMetaDataImpl.addExportedKey((KeyMetaData)object);
                string = bufferedReader.readLine();
                matcher = exportedKeysPattern.matcher(string);
            }
            matcher = tablePatterns[1].matcher(string);
            if (!matcher.matches()) {
                throw new RelationalSchemaParseException(tablePatterns[1].toString());
            }
            return tableMetaDataImpl;
        }
        catch (IOException iOException) {
            throw new RelationalSchemaParseException(iOException.getMessage());
        }
    }
}

