/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.databaseschema;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import uk.org.ogsadai.converters.databaseschema.ColumnMetaData;
import uk.org.ogsadai.converters.databaseschema.ColumnMetaDataImpl;
import uk.org.ogsadai.converters.databaseschema.KeyMetaData;
import uk.org.ogsadai.converters.databaseschema.KeyMetaDataImpl;
import uk.org.ogsadai.converters.databaseschema.ResultSetTableMetaDataException;
import uk.org.ogsadai.converters.databaseschema.TableMetaData;
import uk.org.ogsadai.converters.databaseschema.toxml.SchemaToXMLConverterImpl;

public class TableMetaDataImpl
implements TableMetaData {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    private String mName;
    private String mSchema;
    private String mCatalog;
    private ColumnMetaData[] mColumns;
    private Set mPrimaryKeys = new HashSet();
    private Set mImportedKeys = new HashSet();
    private Set mExportedKeys = new HashSet();
    public static final String JDBC_COL_NAME = "COLUMN_NAME";
    public static final String JDBC_COL_POSITION = "ORDINAL_POSITION";
    public static final String JDBC_COL_DATA_TYPE = "DATA_TYPE";
    public static final String JDBC_COL_TYPE_NAME = "TYPE_NAME";
    public static final String JDBC_COL_SIZE = "COLUMN_SIZE";
    public static final String JDBC_COL_DEC_DIGITS = "DECIMAL_DIGITS";
    public static final String JDBC_FK_TABLE = "FKTABLE_NAME";
    public static final String JDBC_FK_SCHEMA = "FKTABLE_SCHEM";
    public static final String JDBC_FK_CATALOG = "FKTABLE_CAT";
    public static final String JDBC_FK_COL = "FKCOLUMN_NAME";
    public static final String JDBC_PK_TABLE = "PKTABLE_NAME";
    public static final String JDBC_PK_COL = "PKCOLUMN_NAME";

    public TableMetaDataImpl(String string, String string2, String string3) {
        this.mName = string3;
        this.mSchema = string2;
        this.mCatalog = string;
    }

    public void setPrimaryKeys(ResultSet resultSet) throws ResultSetTableMetaDataException {
        if (resultSet == null) {
            return;
        }
        try {
            while (resultSet.next()) {
                this.mPrimaryKeys.add(resultSet.getString(JDBC_COL_NAME));
            }
        }
        catch (SQLException sQLException) {
            throw new ResultSetTableMetaDataException(this.mCatalog, this.mSchema, this.mName, sQLException);
        }
    }

    public void setImportedKeys(ResultSet resultSet) throws ResultSetTableMetaDataException {
        this.setKeys(resultSet, this.mImportedKeys);
    }

    public void setExportedKeys(ResultSet resultSet) throws ResultSetTableMetaDataException {
        this.setKeys(resultSet, this.mExportedKeys);
    }

    private void setKeys(ResultSet resultSet, Set set) throws ResultSetTableMetaDataException {
        try {
            while (resultSet.next()) {
                KeyMetaDataImpl keyMetaDataImpl = new KeyMetaDataImpl();
                keyMetaDataImpl.setPrimaryKeyTableName(resultSet.getString(JDBC_PK_TABLE));
                keyMetaDataImpl.setPrimaryKeyColumnName(resultSet.getString(JDBC_PK_COL));
                keyMetaDataImpl.setForeignTable(resultSet.getString(JDBC_FK_TABLE), resultSet.getString(JDBC_FK_SCHEMA), resultSet.getString(JDBC_FK_CATALOG));
                keyMetaDataImpl.setForeignColumnName(resultSet.getString(JDBC_FK_COL));
                set.add(keyMetaDataImpl);
            }
        }
        catch (SQLException sQLException) {
            throw new ResultSetTableMetaDataException(this.mCatalog, this.mSchema, this.mName, sQLException);
        }
    }

    public void addPrimaryKey(String string) {
        this.mPrimaryKeys.add(string);
    }

    public void addImportedKey(KeyMetaData keyMetaData) {
        this.mImportedKeys.add(keyMetaData);
    }

    public void addExportedKey(KeyMetaData keyMetaData) {
        this.mExportedKeys.add(keyMetaData);
    }

    public void setColumns(ResultSet resultSet) throws ResultSetTableMetaDataException {
        HashSet<ColumnMetaDataImpl> hashSet = new HashSet<ColumnMetaDataImpl>();
        try {
            while (resultSet.next()) {
                ColumnMetaDataImpl columnMetaDataImpl = new ColumnMetaDataImpl(resultSet.getString(JDBC_COL_NAME), resultSet.getInt(JDBC_COL_POSITION), this);
                columnMetaDataImpl.setFullName(this.mName + "_" + columnMetaDataImpl.getName());
                columnMetaDataImpl.setDataType(resultSet.getInt(JDBC_COL_DATA_TYPE));
                columnMetaDataImpl.setTypeName(resultSet.getString(JDBC_COL_TYPE_NAME));
                columnMetaDataImpl.setColumnSize(resultSet.getInt(JDBC_COL_SIZE));
                columnMetaDataImpl.setDecimalDigits(resultSet.getInt(JDBC_COL_DEC_DIGITS));
                columnMetaDataImpl.setNullable(resultSet.getInt("NULLABLE") == 1);
                columnMetaDataImpl.setDefaultValue(resultSet.getString("COLUMN_DEF"));
                hashSet.add(columnMetaDataImpl);
            }
        }
        catch (SQLException sQLException) {
            throw new ResultSetTableMetaDataException(this.mCatalog, this.mSchema, this.mName, sQLException);
        }
        this.setColumns(hashSet.toArray(new ColumnMetaData[0]));
    }

    public void setColumns(ColumnMetaData[] columnMetaDataArray) {
        this.mColumns = new ColumnMetaData[columnMetaDataArray.length];
        for (int i = 0; i < columnMetaDataArray.length; ++i) {
            ColumnMetaData columnMetaData = columnMetaDataArray[i];
            this.mColumns[columnMetaData.getPosition() - 1] = columnMetaDataArray[i];
        }
    }

    public String getName() {
        return this.mName;
    }

    public String getSchemaName() {
        return this.mSchema;
    }

    public String getCatalogName() {
        return this.mCatalog;
    }

    public ColumnMetaData getColumn(int n) {
        if (this.mColumns == null) {
            return null;
        }
        if (n > this.mColumns.length || n < 1) {
            throw new IllegalArgumentException("column must be > 0 and <= " + this.mColumns.length);
        }
        return this.mColumns[n - 1];
    }

    public int getColumnCount() {
        if (this.mColumns == null) {
            return 0;
        }
        return this.mColumns.length;
    }

    public String[] getPrimaryKeys() {
        if (this.mPrimaryKeys == null) {
            return null;
        }
        return this.mPrimaryKeys.toArray(new String[this.mPrimaryKeys.size()]);
    }

    public KeyMetaData[] getImportedKeys() {
        if (this.mImportedKeys == null) {
            return null;
        }
        return this.mImportedKeys.toArray(new KeyMetaDataImpl[this.mImportedKeys.size()]);
    }

    public KeyMetaData[] getExportedKeys() {
        if (this.mExportedKeys == null) {
            return null;
        }
        return this.mExportedKeys.toArray(new KeyMetaDataImpl[this.mExportedKeys.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        SchemaToXMLConverterImpl schemaToXMLConverterImpl = new SchemaToXMLConverterImpl();
        schemaToXMLConverterImpl.write(stringBuffer, this);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof TableMetaDataImpl) {
            return this.toString().equals(object.toString());
        }
        return false;
    }
}

