/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.csv;

import java.io.PushbackReader;
import java.io.Reader;
import java.util.Vector;
import uk.org.ogsadai.converters.csv.CSVConfigurator;
import uk.org.ogsadai.converters.csv.CSVFieldBuilder;
import uk.org.ogsadai.converters.csv.CSVHandler;
import uk.org.ogsadai.converters.csv.CSVParseMismatchedColumnSizeException;
import uk.org.ogsadai.converters.csv.CSVParseUnexpectedDoubleQuotesException;
import uk.org.ogsadai.converters.csv.CSVParseUnexpectedDoubleQuotesInEscapedTextException;

public class CSVParser {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    private CSVConfigurator mConfigurator;
    private CSVHandler mHandler;
    private Reader mInput;
    private CSVFieldBuilder mFieldBuilder = new CSVFieldBuilder();
    private Vector mRow = new Vector();
    private boolean mFieldInDblQuotes = false;
    private boolean mSingleCharNewLine = false;
    private boolean mDoubleCharNewLine = false;
    private boolean mRowInclNull = false;
    private int mLineCount;
    private int mColumnCount;

    public void setConfigurator(CSVConfigurator cSVConfigurator) {
        this.mConfigurator = cSVConfigurator;
    }

    public void setInput(Reader reader) {
        this.mInput = reader;
    }

    public void setOutput(CSVHandler cSVHandler) {
        this.mHandler = cSVHandler;
    }

    public void parse() throws Exception {
        int n;
        this.mLineCount = 0;
        this.mColumnCount = -1;
        char c = this.mConfigurator.getMDelimiter();
        int n2 = 34;
        int n3 = 13;
        int n4 = 10;
        PushbackReader pushbackReader = new PushbackReader(this.mInput);
        while ((n = pushbackReader.read()) != -1) {
            int n5;
            if (n == n2) {
                if (this.mFieldBuilder.getLength() == 0 && !this.mFieldInDblQuotes) {
                    this.mFieldInDblQuotes = true;
                    continue;
                }
                if (this.mFieldInDblQuotes) {
                    n5 = pushbackReader.read();
                    if (n5 == c) {
                        this.addField();
                        continue;
                    }
                    if (n5 == n2) {
                        this.mFieldBuilder.append('\"');
                        continue;
                    }
                    if (n5 == n4 || n5 == n3) {
                        this.mFieldInDblQuotes = false;
                        pushbackReader.unread(n5);
                        continue;
                    }
                    throw new CSVParseUnexpectedDoubleQuotesInEscapedTextException(this.mLineCount + 1, this.mRow.size() + 1);
                }
                throw new CSVParseUnexpectedDoubleQuotesException(this.mLineCount + 1, this.mRow.size() + 1);
            }
            if (n == c) {
                if (this.mFieldInDblQuotes) {
                    this.mFieldBuilder.append(n);
                    continue;
                }
                this.addField();
                continue;
            }
            if (n == n4 || n == n3) {
                if (this.mFieldInDblQuotes) {
                    this.mFieldBuilder.append(n);
                    continue;
                }
                if (this.mSingleCharNewLine) {
                    this.addRow();
                    continue;
                }
                if (this.mDoubleCharNewLine) {
                    pushbackReader.read();
                    this.addRow();
                    continue;
                }
                n5 = pushbackReader.read();
                if (n5 == n4 || n5 == n3) {
                    this.mDoubleCharNewLine = true;
                    this.addRow();
                    continue;
                }
                if (n5 != -1) {
                    this.mSingleCharNewLine = true;
                    this.addRow();
                    pushbackReader.unread(n5);
                    continue;
                }
                if (n5 != -1) continue;
                this.addRow();
                break;
            }
            this.mFieldBuilder.append(n);
        }
        if (this.mRow.size() > 0) {
            this.addRow();
        }
        this.mHandler.putRow(null, false, false);
    }

    private void addField() {
        String string = this.mFieldBuilder.getField();
        if (string.equals(this.mConfigurator.getMNullDataStr())) {
            string = null;
            this.mRowInclNull = true;
        }
        this.mRow.add(string);
        this.mFieldBuilder.reset();
        this.mFieldInDblQuotes = false;
    }

    private void addRow() throws Exception {
        this.addField();
        if (this.mColumnCount == -1) {
            this.mColumnCount = this.mRow.size();
        } else if (this.mRow.size() != this.mColumnCount) {
            if (this.mRow.size() != 1 || ((String)this.mRow.get(0)).trim().length() != 0) {
                throw new CSVParseMismatchedColumnSizeException(this.mLineCount + 1, this.mColumnCount, this.mRow.size());
            }
            this.mRow = new Vector();
            ++this.mLineCount;
            return;
        }
        if (this.mLineCount == 0) {
            if (this.mConfigurator.isMIncludeHeader()) {
                this.mHandler.putRow(this.mRow, true, this.mRowInclNull);
            } else {
                this.mHandler.putRow(this.mRow, false, this.mRowInclNull);
            }
        } else {
            this.mHandler.putRow(this.mRow, false, this.mRowInclNull);
        }
        this.mRow = new Vector();
        ++this.mLineCount;
        this.mRowInclNull = false;
    }
}

