/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.converters.csv;

import uk.org.ogsadai.converters.csv.CSVConfigurationIllegalDelimeterException;
import uk.org.ogsadai.converters.csv.CSVConfigurationIllegalLinebreakException;
import uk.org.ogsadai.converters.csv.CSVConfigurationIllegalNullStringException;

public class CSVConfigurator {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private String mLineBreakChars = "\n";
    private String mLineBreak = "LF";
    private String mDelimiter = ",";
    private String mNullDataStr = "NULL";
    private boolean mIncludeHeader = true;
    private boolean mEscapeFields = true;

    public String getMLineBreakChars() {
        return this.mLineBreakChars;
    }

    public String getMLineBreak() {
        return this.mLineBreak;
    }

    public void setMLineBreak(String string) throws CSVConfigurationIllegalLinebreakException {
        String string2 = null;
        if (string.equals("LF")) {
            string2 = "\n";
        } else if (string.equals("CR")) {
            string2 = "\r";
        } else if (string.equals("LFCR")) {
            string2 = "\r\n";
        } else {
            throw new CSVConfigurationIllegalLinebreakException(string2);
        }
        if (string2.equals(this.mDelimiter) || string2.equals(this.mNullDataStr)) {
            throw new CSVConfigurationIllegalLinebreakException(string2);
        }
        this.mLineBreak = string;
        this.mLineBreakChars = string2;
    }

    public String getMNullDataStr() {
        return this.mNullDataStr;
    }

    public void setMNullDataStr(String string) throws CSVConfigurationIllegalNullStringException {
        if (string.equals(this.mDelimiter) || string.equals(this.mLineBreakChars) || string.matches(".*[\"].*")) {
            throw new CSVConfigurationIllegalNullStringException(string);
        }
        this.mNullDataStr = string;
    }

    public boolean isMIncludeHeader() {
        return this.mIncludeHeader;
    }

    public void setMIncludeHeader(boolean bl) {
        this.mIncludeHeader = bl;
    }

    public char getMDelimiter() {
        return this.mDelimiter.charAt(0);
    }

    public void setMDelimiter(char c) throws CSVConfigurationIllegalDelimeterException {
        String string = "" + c;
        if (string.equals(this.mLineBreakChars) || string.equals(this.mNullDataStr) || string.equals("\"")) {
            throw new CSVConfigurationIllegalDelimeterException(string);
        }
        this.mDelimiter = string;
    }

    public boolean isMEscapeFields() {
        return this.mEscapeFields;
    }

    public void setMEscapeFields(boolean bl) {
        this.mEscapeFields = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("lineBreak:\t" + this.mLineBreak + "\n");
        stringBuffer.append("delimiter:\t" + this.mDelimiter + "\n");
        stringBuffer.append("nullDataStr:\t" + this.mNullDataStr + "\n");
        stringBuffer.append("includeHeader:\t" + this.mIncludeHeader + "\n");
        stringBuffer.append("escapeFields:\t" + this.mEscapeFields + "\n");
        return stringBuffer.toString();
    }
}

