/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.msgs;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.common.msgs.DAIResourceBundle;
import uk.org.ogsadai.common.msgs.DAIUniqueID;
import uk.org.ogsadai.common.msgs.MessageID;
import uk.org.ogsadai.exception.ErrorID;

public class MessageLoader {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) International Business Machines Corporation, 2002-2005, Copyright (c) The University of Edinburgh,  2002-2007.";
    private static DAILogger LOG = DAILogger.getLogger(MessageLoader.class);
    private static DAIResourceBundle mBundle = null;

    private MessageLoader() {
    }

    private static String getString(String string) {
        String string2 = null;
        if (mBundle != null) {
            try {
                string2 = mBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                LOG.warn(ErrorID.MISSING_MESSAGE_ERROR, new Object[]{missingResourceException.getKey()});
            }
        }
        return string2;
    }

    private static String getLocalizedMessage(String string) {
        String string2 = MessageLoader.getString(string);
        if (string2 == null) {
            string2 = MessageLoader.getMessage(string);
        }
        return string2;
    }

    private static String getLocalizedMessage(String string, DAIUniqueID dAIUniqueID) {
        String string2 = MessageLoader.getString(string);
        if (string2 == null) {
            string2 = MessageLoader.getMessage(string, dAIUniqueID);
        }
        return string2;
    }

    private static String getLocalizedMessage(String string, Object[] objectArray) {
        String string2;
        String string3 = MessageLoader.getString(string);
        if (string3 != null) {
            MessageFormat messageFormat = new MessageFormat(string3);
            messageFormat.setLocale(Locale.getDefault());
            string2 = messageFormat.format(objectArray);
        } else {
            string2 = MessageLoader.getMessage(string, objectArray);
        }
        return string2;
    }

    private static String getLocalizedMessage(String string, Object[] objectArray, DAIUniqueID dAIUniqueID) {
        String string2;
        String string3 = MessageLoader.getString(string);
        if (string3 != null) {
            MessageFormat messageFormat = new MessageFormat(string3);
            messageFormat.setLocale(Locale.getDefault());
            string2 = messageFormat.format(objectArray);
        } else {
            string2 = MessageLoader.getMessage(string, objectArray, dAIUniqueID);
        }
        return string2;
    }

    private static String getMessage(String string) {
        return string;
    }

    private static String getMessage(String string, DAIUniqueID dAIUniqueID) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(dAIUniqueID);
        stringBuffer.append("] ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static String getMessage(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(i == 0 ? " : " : ", ");
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.toString();
    }

    private static String getMessage(String string, Object[] objectArray, DAIUniqueID dAIUniqueID) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(dAIUniqueID);
        stringBuffer.append("] ");
        stringBuffer.append(string);
        if (objectArray != null) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(i == 0 ? " : " : ", ");
                stringBuffer.append(objectArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    public static String getLocalizedMessage(MessageID messageID) {
        return MessageLoader.getLocalizedMessage(messageID.toString());
    }

    public static String getLocalizedMessage(MessageID messageID, DAIUniqueID dAIUniqueID) {
        return MessageLoader.getLocalizedMessage(messageID.toString(), dAIUniqueID);
    }

    public static String getLocalizedMessage(MessageID messageID, Object[] objectArray) {
        return MessageLoader.getLocalizedMessage(messageID.toString(), objectArray);
    }

    public static String getLocalizedMessage(MessageID messageID, Object[] objectArray, DAIUniqueID dAIUniqueID) {
        if (messageID == null) {
            return "Cannot generate message string - key is null";
        }
        return MessageLoader.getLocalizedMessage(messageID.toString(), objectArray, dAIUniqueID);
    }

    public static String getMessage(MessageID messageID) {
        return MessageLoader.getMessage(messageID.toString());
    }

    public static String getMessage(MessageID messageID, DAIUniqueID dAIUniqueID) {
        return MessageLoader.getMessage(messageID.toString(), dAIUniqueID);
    }

    public static String getMessage(MessageID messageID, Object[] objectArray) {
        return MessageLoader.getMessage(messageID.toString(), objectArray);
    }

    public static String getMessage(MessageID messageID, Object[] objectArray, DAIUniqueID dAIUniqueID) {
        return MessageLoader.getMessage(messageID.toString(), objectArray, dAIUniqueID);
    }

    public static void registerMessageBundle(String string, Locale locale) {
        try {
            if (string != null) {
                mBundle.registerResourceBundle(string, locale);
            }
        }
        catch (MissingResourceException missingResourceException) {
            LOG.warn(ErrorID.MISSING_MESSAGE_BUNDLE_ERROR, new Object[]{missingResourceException.getKey()});
        }
    }

    static {
        try {
            mBundle = new DAIResourceBundle();
        }
        catch (MissingResourceException missingResourceException) {
            LOG.warn(ErrorID.MISSING_MESSAGE_BUNDLE_ERROR, new Object[]{missingResourceException.getKey()});
        }
    }
}

