/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.msgs;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;
import uk.org.ogsadai.common.msgs.DAIUniqueID;
import uk.org.ogsadai.common.msgs.MessageID;
import uk.org.ogsadai.common.msgs.MessageLoader;
import uk.org.ogsadai.exception.DAIExceptionInformation;
import uk.org.ogsadai.exception.ErrorID;

public class DAILogger {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) International Business Machines Corporation, 2002-2005, Copyright (c) The University of Edinburgh,  2002-2007.";
    private Class mClass;
    private Logger mLogger;
    private boolean debugEnabled;

    public static DAILogger getLogger(Class clazz) {
        return new DAILogger(clazz);
    }

    private DAILogger(Class clazz) {
        this.mLogger = Logger.getLogger((Class)clazz);
        this.mClass = clazz;
        this.debugEnabled = this.mLogger.isDebugEnabled();
    }

    public void debug(String string) {
        this.mLogger.debug((Object)string);
    }

    public void debug(DAIUniqueID dAIUniqueID, String string) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)this.addIDToMessage(dAIUniqueID, string));
        }
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void info(MessageID messageID) {
        this.info(messageID, new Object[0]);
    }

    public void info(MessageID messageID, Object object) {
        this.info(messageID, new Object[]{object});
    }

    public void info(MessageID messageID, Object[] objectArray) {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.getLocalizedMessage(messageID, objectArray));
        }
    }

    public boolean isInfoEnabled() {
        return this.mLogger.isInfoEnabled();
    }

    public DAIUniqueID warn(Throwable throwable) {
        return this.warnExceptionAndChildren(throwable, false);
    }

    public DAIUniqueID warn(Throwable throwable, boolean bl) {
        return this.warnExceptionAndChildren(throwable, bl);
    }

    public DAIUniqueID error(Throwable throwable) {
        return this.errorExceptionAndChildren(throwable, false);
    }

    public DAIUniqueID error(Throwable throwable, boolean bl) {
        return this.errorExceptionAndChildren(throwable, bl);
    }

    public void warn(ErrorID errorID, Object[] objectArray) {
        this.mLogger.warn((Object)MessageLoader.getMessage((MessageID)errorID, objectArray));
    }

    public DAIUniqueID fatal(Throwable throwable) {
        return this.fatalExceptionAndChildren(throwable, false);
    }

    public DAIUniqueID fatal(Throwable throwable, boolean bl) {
        return this.fatalExceptionAndChildren(throwable, bl);
    }

    private DAIUniqueID warnExceptionAndChildren(Throwable throwable, boolean bl) {
        DAIUniqueID dAIUniqueID = throwable instanceof DAIExceptionInformation ? ((DAIExceptionInformation)((Object)throwable)).getExceptionID() : DAIUniqueID.newInstance();
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            String string = "";
            if (throwable2 instanceof DAIExceptionInformation) {
                DAIExceptionInformation dAIExceptionInformation = (DAIExceptionInformation)((Object)throwable2);
                string = this.getLocalizedMessage(dAIUniqueID, dAIExceptionInformation.getErrorID(), dAIExceptionInformation.getParameters());
            } else {
                string = this.addIDToMessage(dAIUniqueID, throwable2.getClass().getName() + ": " + throwable2.getLocalizedMessage());
            }
            this.mLogger.warn((Object)string);
        }
        if (bl) {
            this.logStackTraceWarn(throwable);
        }
        return dAIUniqueID;
    }

    private DAIUniqueID errorExceptionAndChildren(Throwable throwable, boolean bl) {
        DAIUniqueID dAIUniqueID = throwable instanceof DAIExceptionInformation ? ((DAIExceptionInformation)((Object)throwable)).getExceptionID() : DAIUniqueID.newInstance();
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            String string = "";
            if (throwable2 instanceof DAIExceptionInformation) {
                DAIExceptionInformation dAIExceptionInformation = (DAIExceptionInformation)((Object)throwable2);
                string = this.getLocalizedMessage(dAIUniqueID, dAIExceptionInformation.getErrorID(), dAIExceptionInformation.getParameters());
            } else {
                string = this.addIDToMessage(dAIUniqueID, throwable2.getClass().getName() + ": " + throwable2.getLocalizedMessage());
            }
            this.mLogger.error((Object)string);
        }
        if (bl) {
            this.logStackTraceError(throwable);
        }
        return dAIUniqueID;
    }

    private DAIUniqueID fatalExceptionAndChildren(Throwable throwable, boolean bl) {
        DAIUniqueID dAIUniqueID = throwable instanceof DAIExceptionInformation ? ((DAIExceptionInformation)((Object)throwable)).getExceptionID() : DAIUniqueID.newInstance();
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            String string = "";
            if (throwable2 instanceof DAIExceptionInformation) {
                DAIExceptionInformation dAIExceptionInformation = (DAIExceptionInformation)((Object)throwable2);
                string = this.getLocalizedMessage(dAIUniqueID, dAIExceptionInformation.getErrorID(), dAIExceptionInformation.getParameters());
            } else {
                string = this.addIDToMessage(dAIUniqueID, throwable2.getClass().getName() + ": " + throwable2.getLocalizedMessage());
            }
            this.mLogger.fatal((Object)string);
        }
        if (bl) {
            this.logStackTraceFatal(throwable);
        }
        return dAIUniqueID;
    }

    public String getLocalizedMessage(MessageID messageID, Object[] objectArray) {
        return MessageLoader.getLocalizedMessage(messageID, objectArray);
    }

    private String getLocalizedMessage(DAIUniqueID dAIUniqueID, MessageID messageID, Object[] objectArray) {
        String string = this.getLocalizedMessage(messageID, objectArray);
        return this.addIDToMessage(dAIUniqueID, string);
    }

    private String addIDToMessage(DAIUniqueID dAIUniqueID, String string) {
        return "#" + dAIUniqueID.toString() + "# " + string;
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private void logStackTraceDebug(Throwable throwable) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)this.getStackTrace(throwable));
        }
    }

    private void logStackTraceWarn(Throwable throwable) {
        this.mLogger.warn((Object)this.getStackTrace(throwable));
    }

    private void logStackTraceError(Throwable throwable) {
        this.mLogger.error((Object)this.getStackTrace(throwable));
    }

    private void logStackTraceFatal(Throwable throwable) {
        this.mLogger.fatal((Object)this.getStackTrace(throwable));
    }
}

