/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common.files;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Vector;
import uk.org.ogsadai.common.files.FileException;
import uk.org.ogsadai.common.files.FileIOException;
import uk.org.ogsadai.common.files.FileNotFoundException;

public class TextFileUtils {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2007.";

    public boolean containsLine(File file, String string) throws FileException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException(file);
        }
        boolean bl = false;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.equals(string)) {
                    bl = true;
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            inputStreamReader.close();
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            throw new FileIOException(file, (Throwable)exception);
        }
        return bl;
    }

    public List getLines(File file) throws FileException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException(file);
        }
        Vector<String> vector = new Vector<String>();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            while (string != null) {
                vector.add(string);
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
            inputStreamReader.close();
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            throw new FileIOException(file, (Throwable)exception);
        }
        return vector;
    }

    public List getLines(File file, String string) throws FileException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException(file);
        }
        Vector<String> vector = new Vector<String>();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.startsWith(string)) {
                    vector.add(string2);
                }
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            inputStreamReader.close();
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            throw new FileIOException(file, (Throwable)exception);
        }
        return vector;
    }

    public List getLines(File file, String string, String string2) throws FileException {
        return this.getLines(file, string, string, string2, string2);
    }

    public List getLines(File file, String string, String string2, String string3, String string4) throws FileException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException(file);
        }
        Vector<String> vector = new Vector<String>();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string5 = bufferedReader.readLine();
            boolean bl = false;
            boolean bl2 = false;
            while (string5 != null) {
                if (string5.equals(string) && !bl) {
                    bl = true;
                }
                if (string5.equals(string2) && bl) {
                    vector.add(string5);
                    bl2 = true;
                    if (string5.equals(string3)) {
                        break;
                    }
                } else {
                    if (bl2 && string5.equals(string3)) {
                        vector.add(string5);
                        break;
                    }
                    if (bl2 && string5.equals(string4)) {
                        vector.add(string5);
                        break;
                    }
                    if (!bl2 && bl && string5.equals(string4)) break;
                    if (bl2 && !string5.startsWith("#")) {
                        vector.add(string5);
                    }
                }
                string5 = bufferedReader.readLine();
            }
            bufferedReader.close();
            inputStreamReader.close();
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            throw new FileIOException(file, (Throwable)exception);
        }
        return vector;
    }

    public void deleteLines(File file, String string, String string2) throws FileException {
        this.deleteLines(file, string, string, string2);
    }

    public void deleteLines(File file, String string, String string2, String string3) throws FileException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException(file);
        }
        Vector<String> vector = new Vector<String>();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string4 = bufferedReader.readLine();
            boolean bl = false;
            boolean bl2 = false;
            while (string4 != null) {
                if (string4.equals(string) && !bl) {
                    bl = true;
                }
                if (string4.equals(string2) && bl) {
                    bl2 = true;
                }
                if (bl2 && string4.equals(string3)) {
                    bl = false;
                    string4 = bufferedReader.readLine();
                    break;
                }
                if (!bl2) {
                    vector.add(string4);
                }
                string4 = bufferedReader.readLine();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            for (int i = 0; i < vector.size(); ++i) {
                outputStreamWriter.write((String)vector.get(i));
                outputStreamWriter.write("\n");
            }
            while (string4 != null) {
                outputStreamWriter.write(string4);
                outputStreamWriter.write("\n");
                string4 = bufferedReader.readLine();
            }
            bufferedReader.close();
            inputStreamReader.close();
            ((InputStream)fileInputStream).close();
            outputStreamWriter.flush();
            outputStreamWriter.close();
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            throw new FileIOException(file, (Throwable)exception);
        }
    }

    public void deleteLine(File file, String string, String string2) throws FileException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException(file);
        }
        Vector<String> vector = new Vector<String>();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = bufferedReader.readLine();
            boolean bl = false;
            while (string3 != null) {
                if (string3.equals(string) && !bl) {
                    bl = true;
                }
                if (string3.startsWith(string2) && bl) {
                    string3 = bufferedReader.readLine();
                    break;
                }
                vector.add(string3);
                string3 = bufferedReader.readLine();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            for (int i = 0; i < vector.size(); ++i) {
                outputStreamWriter.write((String)vector.get(i));
                outputStreamWriter.write("\n");
            }
            while (string3 != null) {
                outputStreamWriter.write(string3);
                outputStreamWriter.write("\n");
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
            inputStreamReader.close();
            ((InputStream)fileInputStream).close();
            outputStreamWriter.flush();
            outputStreamWriter.close();
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            throw new FileIOException(file, (Throwable)exception);
        }
    }

    public void replaceLines(File file, String string, String string2, List list) throws FileException {
        this.replaceLines(file, string, string, string2, list);
    }

    public void replaceLines(File file, String string, String string2, String string3, List list) throws FileException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException(file);
        }
        if (list == null) {
            throw new IllegalArgumentException("replacements must not be null");
        }
        Vector<String> vector = new Vector<String>();
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string4 = bufferedReader.readLine();
            boolean bl = false;
            boolean bl2 = false;
            while (string4 != null) {
                if (string4.equals(string) && !bl) {
                    bl = true;
                }
                if (string4.equals(string2) && bl) {
                    bl2 = true;
                }
                if (bl2 && string4.equals(string3)) {
                    string4 = bufferedReader.readLine();
                    break;
                }
                if (!bl2) {
                    vector.add(string4);
                }
                string4 = bufferedReader.readLine();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            for (n = 0; n < vector.size(); ++n) {
                outputStreamWriter.write((String)vector.get(n));
                outputStreamWriter.write("\n");
            }
            if (bl2) {
                for (n = 0; n < list.size(); ++n) {
                    outputStreamWriter.write((String)list.get(n));
                    outputStreamWriter.write("\n");
                }
            }
            while (string4 != null) {
                outputStreamWriter.write(string4);
                outputStreamWriter.write("\n");
                string4 = bufferedReader.readLine();
            }
            bufferedReader.close();
            inputStreamReader.close();
            ((InputStream)fileInputStream).close();
            outputStreamWriter.flush();
            outputStreamWriter.close();
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            throw new FileIOException(file, (Throwable)exception);
        }
    }

    public void replaceLine(File file, String string, String string2, String string3) throws FileException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException(file);
        }
        Vector<String> vector = new Vector<String>();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string4 = bufferedReader.readLine();
            boolean bl = false;
            boolean bl2 = false;
            while (string4 != null) {
                if (string4.equals(string) && !bl) {
                    bl = true;
                }
                if (string4.startsWith(string2) && bl) {
                    bl2 = true;
                    string4 = bufferedReader.readLine();
                    break;
                }
                vector.add(string4);
                string4 = bufferedReader.readLine();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            for (int i = 0; i < vector.size(); ++i) {
                outputStreamWriter.write((String)vector.get(i));
                outputStreamWriter.write("\n");
            }
            if (bl2) {
                outputStreamWriter.write(string3);
                outputStreamWriter.write("\n");
            }
            while (string4 != null) {
                outputStreamWriter.write(string4);
                outputStreamWriter.write("\n");
                string4 = bufferedReader.readLine();
            }
            bufferedReader.close();
            inputStreamReader.close();
            ((InputStream)fileInputStream).close();
            outputStreamWriter.flush();
            outputStreamWriter.close();
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            throw new FileIOException(file, (Throwable)exception);
        }
    }

    public void replaceLines(File file, List list) throws FileException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException(file);
        }
        if (list == null) {
            throw new IllegalArgumentException("replacements must not be null");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            for (int i = 0; i < list.size(); ++i) {
                outputStreamWriter.write((String)list.get(i));
                outputStreamWriter.write("\n");
            }
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            throw new FileIOException(file, (Throwable)exception);
        }
    }

    public void insertLines(File file, String string, List list) throws FileException {
        this.insertLines(file, string, string, list);
    }

    public void insertLines(File file, String string, String string2, List list) throws FileException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException(file);
        }
        if (list == null) {
            throw new IllegalArgumentException("lines must not be null");
        }
        List list2 = this.getLines(file);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < list2.size(); ++i) {
                String string3 = (String)list2.get(i);
                outputStreamWriter.write(string3);
                outputStreamWriter.write("\n");
                if (!bl2 && string3.equals(string)) {
                    bl = true;
                }
                if (bl2 || !bl || !string3.equals(string2)) continue;
                for (int j = 0; j < list.size(); ++j) {
                    outputStreamWriter.write((String)list.get(j));
                    outputStreamWriter.write("\n");
                }
                bl2 = true;
            }
            outputStreamWriter.flush();
            outputStreamWriter.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new FileIOException(file, (Throwable)exception);
        }
    }

    public void appendLines(File file, List list) throws FileException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException(file);
        }
        if (list == null) {
            throw new IllegalArgumentException("lines must not be null");
        }
        List list2 = this.getLines(file);
        list2.addAll(list);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            for (int i = 0; i < list2.size(); ++i) {
                String string = (String)list2.get(i);
                outputStreamWriter.write(string);
                outputStreamWriter.write("\n");
            }
            outputStreamWriter.flush();
            outputStreamWriter.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new FileIOException(file, (Throwable)exception);
        }
    }
}

