/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BinaryLob
implements Blob {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) International Business Machines Corporation, 2002-2005, Copyright (c) The University of Edinburgh,  2002-2007.";
    protected byte[] mByteArray = null;

    public long length() throws SQLException {
        if (this.mByteArray == null) {
            throw new SQLException("There is no BLOB data");
        }
        return this.mByteArray.length;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (this.mByteArray == null) {
            throw new SQLException("There is no BLOB data");
        }
        int n2 = this.mByteArray.length;
        if (l < 1L || l > (long)n2) {
            throw new IllegalArgumentException("Position must be > 0 and <= number of bytes");
        }
        if (n > n2) {
            throw new IllegalArgumentException("Length must be <= number of bytes");
        }
        if (l + (long)n > (long)n2) {
            throw new IllegalArgumentException("Position + length must be <= number of bytes");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.mByteArray, (int)l - 1, byArray, 0, n);
        return byArray;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.mByteArray == null) {
            throw new SQLException("There is no BLOB data");
        }
        return new ByteArrayInputStream(this.mByteArray);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (this.mByteArray == null) {
            this.mByteArray = new byte[(int)l - 1 + n2];
        }
        if (l - 1L + (long)n2 > (long)this.mByteArray.length) {
            byte[] byArray2 = this.mByteArray;
            this.mByteArray = new byte[(int)l - 1 + n2];
            System.arraycopy(byArray2, 0, this.mByteArray, 0, byArray2.length);
        }
        System.arraycopy(byArray, n, this.mByteArray, (int)l - 1, n2);
        return n2;
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        throw new UnsupportedOperationException("setBinaryStream");
    }

    public long position(byte[] byArray, long l) throws SQLException {
        throw new UnsupportedOperationException("position");
    }

    public long position(Blob blob, long l) throws SQLException {
        throw new UnsupportedOperationException("position");
    }

    public void truncate(long l) throws SQLException {
        if (this.mByteArray == null) {
            throw new SQLException("There is no BLOB data");
        }
        if (l < (long)this.mByteArray.length) {
            byte[] byArray = new byte[(int)l];
            System.arraycopy(this.mByteArray, 0, byArray, 0, (int)l);
            this.mByteArray = byArray;
        }
    }
}

