/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common;

import java.lang.reflect.Method;
import uk.org.ogsadai.common.Base64InitialisationException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.exception.ExternalModuleException;

public class Base64 {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2007";
    private static DAILogger LOGGER = DAILogger.getLogger(Base64.class);
    public static String BASE64_CLASS_PROPERTY = "uk.org.ogsadai.Base64";
    private static Method mDecode;
    private static Method mEncode;
    private static Method mEncodeBytes;
    private static String mBase64Class;
    private static String mDefaultClass;

    public static synchronized void registerBase64Class(String string) {
        mBase64Class = string;
        Base64.initBase64();
    }

    public static String encode(byte[] byArray) {
        if (mEncode == null) {
            Base64.initBase64();
        }
        try {
            return (String)mEncode.invoke(null, new Object[]{byArray});
        }
        catch (Throwable throwable) {
            throw new ExternalModuleException(throwable);
        }
    }

    public static String encode(byte[] byArray, int n, int n2) {
        if (mEncode == null) {
            Base64.initBase64();
        }
        try {
            return (String)mEncodeBytes.invoke(null, byArray, new Integer(n), new Integer(n2));
        }
        catch (Throwable throwable) {
            throw new ExternalModuleException(throwable);
        }
    }

    public static byte[] decode(byte[] byArray) {
        return Base64.decode(new String(byArray));
    }

    public static byte[] decode(String string) {
        if (mEncode == null) {
            Base64.initBase64();
        }
        try {
            return (byte[])mDecode.invoke(null, string);
        }
        catch (Throwable throwable) {
            throw new ExternalModuleException(throwable);
        }
    }

    private static synchronized void initBase64() {
        String string = mBase64Class;
        if (string == null) {
            string = mDefaultClass;
        }
        try {
            Class<?> clazz = Class.forName(string);
            mDecode = clazz.getMethod("decode", String.class);
            mEncode = clazz.getMethod("encode", [B.class);
            mEncodeBytes = clazz.getMethod("encode", [B.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {
            throw new Base64InitialisationException(throwable);
        }
    }

    static {
        mDefaultClass = "org.apache.axis.encoding.Base64";
    }
}

