/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.resource.property;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import uk.org.ogsadai.exception.ResourcePropertyValueNodeTypeException;
import uk.org.ogsadai.exception.ResourcePropertyValueNotSingleChildException;
import uk.org.ogsadai.exception.ResourcePropertyValueParseException;
import uk.org.ogsadai.util.xml.XML;

public class StringPropertyConvertor {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";

    private StringPropertyConvertor() {
    }

    public static String deserialize(Node[] nodeArray) throws ResourcePropertyValueParseException {
        if (nodeArray.length != 1) {
            throw new ResourcePropertyValueNotSingleChildException(nodeArray.length);
        }
        Node node = nodeArray[0];
        if (!(node instanceof Text)) {
            throw new ResourcePropertyValueNodeTypeException(Text.class);
        }
        return ((Text)node).getData();
    }

    public static Node[] serialize(String string) {
        Document document = XML.getNewDocument();
        Text text = document.createTextNode(string);
        return new Node[]{text};
    }
}

