/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.resource.property;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uk.org.ogsadai.activity.ActivityContractName;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.resource.property.ActivityMetaData;

public class SimpleActivityMetaData
implements ActivityMetaData {
    private static final String COPYRIGHT_NOTICE = "University of Edinburgh 2002 - 2007.";
    private ActivityName mActivityName;
    private String mDescription;
    private List mActivityContracts;

    public SimpleActivityMetaData() {
        this.mActivityName = new ActivityName("UnnamedActivity");
        this.mDescription = "";
        this.mActivityContracts = new LinkedList();
    }

    public SimpleActivityMetaData(ActivityName activityName) {
        this.mActivityName = activityName;
        this.mDescription = "";
        this.mActivityContracts = new LinkedList();
    }

    public SimpleActivityMetaData(ActivityName activityName, ActivityContractName[] activityContractNameArray) {
        this(activityName, "", activityContractNameArray);
    }

    public SimpleActivityMetaData(ActivityName activityName, String string, ActivityContractName[] activityContractNameArray) {
        this.mActivityName = activityName;
        this.mDescription = string;
        this.mActivityContracts = Arrays.asList(activityContractNameArray);
    }

    public ActivityName getActivityName() {
        return this.mActivityName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public ActivityContractName[] getActivityContracts() {
        return this.mActivityContracts.toArray(new ActivityContractName[0]);
    }

    public void setActivityName(ActivityName activityName) {
        this.mActivityName = activityName;
    }

    public void setDescription(String string) {
        this.mDescription = string != null ? string : "";
    }

    public void addActivityContract(ActivityContractName activityContractName) {
        this.mActivityContracts.add(activityContractName);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ActivityMetaData: name='");
        stringBuffer.append(this.mActivityName);
        stringBuffer.append("' description='");
        stringBuffer.append(this.mDescription);
        stringBuffer.append("' contracts={");
        boolean bl = true;
        Iterator iterator = this.mActivityContracts.iterator();
        while (iterator.hasNext()) {
            ActivityContractName activityContractName = (ActivityContractName)iterator.next();
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("'");
            stringBuffer.append(activityContractName.toString());
            stringBuffer.append("'");
            bl = false;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleActivityMetaData)) {
            return false;
        }
        SimpleActivityMetaData simpleActivityMetaData = (SimpleActivityMetaData)object;
        return this.mActivityName.equals(simpleActivityMetaData.mActivityName) && this.mDescription.equals(simpleActivityMetaData.mDescription) && ((Object)this.mActivityContracts).equals(simpleActivityMetaData.mActivityContracts);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.mActivityName.hashCode();
        n = 37 * n + this.mDescription.hashCode();
        n = 37 * n + ((Object)this.mActivityContracts).hashCode();
        return n;
    }
}

