/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.resource.property;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.w3c.dom.Node;
import uk.org.ogsadai.exception.ResourcePropertyValueDateParseException;
import uk.org.ogsadai.exception.ResourcePropertyValueParseException;
import uk.org.ogsadai.resource.property.StringPropertyConvertor;

public class DatePropertyConvertor {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";

    private DatePropertyConvertor() {
    }

    public static Date deserialize(Node[] nodeArray) throws ResourcePropertyValueParseException {
        String string = StringPropertyConvertor.deserialize(nodeArray);
        if (string == null) {
            return null;
        }
        try {
            return DatePropertyConvertor.parseXSDDate(string);
        }
        catch (ParseException parseException) {
            throw new ResourcePropertyValueDateParseException((Exception)parseException);
        }
    }

    public static Node[] serialize(Date date) {
        String string = null;
        if (date != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            string = simpleDateFormat.format(date);
        }
        return StringPropertyConvertor.serialize(string);
    }

    public static Node[] serialize(Calendar calendar) {
        Date date = null;
        if (calendar != null) {
            date = calendar.getTime();
        }
        return DatePropertyConvertor.serialize(date);
    }

    public static String mapXSDDateTimeStringToStandardDateTimeString(String string) {
        String string2;
        String string3 = string;
        if (string3.startsWith("-")) {
            string3 = string3.substring(1);
        }
        if (string3.endsWith("Z")) {
            string3 = string3.replaceAll("Z", "+0000");
        }
        String string4 = ".000";
        String string5 = "+0000";
        if (string3.length() <= 19) {
            string2 = string3;
        } else {
            string2 = string3.substring(0, 19);
            String string6 = string3.substring(19);
            int n = Math.max(string6.indexOf("+"), string6.indexOf("-"));
            if (n == -1) {
                string4 = string6;
            } else {
                string5 = string6.substring(n);
                string4 = string6.substring(0, n);
            }
            string5 = string5.replaceAll(":", "");
            if (string4.length() > 4) {
                string4 = string4.substring(0, string4.length() > 4 ? 4 : string4.length());
            }
            if (string4.equals("")) {
                string4 = ".000";
            }
        }
        return string2 + string4 + string5;
    }

    public static Date parseXSDDate(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        String string2 = DatePropertyConvertor.mapXSDDateTimeStringToStandardDateTimeString(string);
        Date date = simpleDateFormat.parse(string2);
        return date;
    }
}

