/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.resource.property;

import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityContractName;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.common.ID;
import uk.org.ogsadai.exception.ResourcePropertyValueParseException;
import uk.org.ogsadai.resource.property.ActivitiesMetaData;
import uk.org.ogsadai.resource.property.ActivityMetaData;
import uk.org.ogsadai.resource.property.SimpleActivityMetaData;
import uk.org.ogsadai.resource.property.SimpleResourceActivityMetaData;
import uk.org.ogsadai.util.xml.XML;

public class ActivitiesMetaDataPropertyConvertor {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    public static final String NAMESPACE = "http://ogsadai.org.uk/namespaces/2007/04/types";
    private static final String ACTIVITY_ELEMENT = "activity";
    private static final String ACTIVITY_NAME_ATTRIBUTE = "name";
    private static final String ACTIVITY_DESCRIPTION_ELEMENT = "description";
    private static final String ACTIVITY_CONTRACT_ELEMENT = "contract";
    private static final String ACTIVITY_CONTRACT_NAME_ATTRIBUTE = "name";

    private ActivitiesMetaDataPropertyConvertor() {
    }

    public static Node[] serialize(ActivitiesMetaData activitiesMetaData) {
        Document document = XML.getNewDocument();
        ActivityMetaData[] activityMetaDataArray = activitiesMetaData.getActivityMetaData();
        Node[] nodeArray = new Node[activityMetaDataArray.length];
        for (int i = 0; i < activityMetaDataArray.length; ++i) {
            nodeArray[i] = ActivitiesMetaDataPropertyConvertor.serialiseActivityMetaData(document, activityMetaDataArray[i]);
        }
        return nodeArray;
    }

    public static ActivitiesMetaData deserialize(Node[] nodeArray) throws ResourcePropertyValueParseException {
        SimpleResourceActivityMetaData simpleResourceActivityMetaData = new SimpleResourceActivityMetaData();
        for (int i = 0; i < nodeArray.length; ++i) {
            Element element = (Element)nodeArray[i];
            ActivityMetaData activityMetaData = ActivitiesMetaDataPropertyConvertor.deserializeActivityElement(element);
            simpleResourceActivityMetaData.addActivityMetaData(activityMetaData);
        }
        return simpleResourceActivityMetaData;
    }

    private static ActivityMetaData deserializeActivityElement(Element element) {
        Object object;
        SimpleActivityMetaData simpleActivityMetaData = new SimpleActivityMetaData();
        ActivityName activityName = new ActivityName(element.getAttribute("name"));
        simpleActivityMetaData.setActivityName(activityName);
        NodeList nodeList = element.getElementsByTagNameNS(NAMESPACE, ACTIVITY_DESCRIPTION_ELEMENT);
        if (nodeList.getLength() > 0) {
            object = XML.getText((Element)((Element)nodeList.item(0)));
            simpleActivityMetaData.setDescription((String)object);
        }
        object = element.getElementsByTagNameNS(NAMESPACE, ACTIVITY_CONTRACT_ELEMENT);
        for (int i = 0; i < object.getLength(); ++i) {
            String string = ((Element)object.item(i)).getAttribute("name");
            simpleActivityMetaData.addActivityContract(new ActivityContractName(string));
        }
        return simpleActivityMetaData;
    }

    private static Node serialiseActivityMetaData(Document document, ActivityMetaData activityMetaData) {
        Object object;
        Element element = ActivitiesMetaDataPropertyConvertor.createNewElement(document, ACTIVITY_ELEMENT);
        element.setAttributeNS(NAMESPACE, "name", activityMetaData.getActivityName().toString());
        String string = activityMetaData.getDescription();
        if (string.length() > 0) {
            object = ActivitiesMetaDataPropertyConvertor.createNewElement(document, ACTIVITY_DESCRIPTION_ELEMENT);
            CDATASection cDATASection = document.createCDATASection(string);
            object.appendChild(cDATASection);
            element.appendChild((Node)object);
        }
        object = activityMetaData.getActivityContracts();
        for (int i = 0; i < ((ActivityContractName[])object).length; ++i) {
            Element element2 = ActivitiesMetaDataPropertyConvertor.createNewElement(document, ACTIVITY_CONTRACT_ELEMENT);
            element2.setAttributeNS(NAMESPACE, "name", ((ID)object[i]).toString());
            element.appendChild(element2);
        }
        return element;
    }

    private static Element createNewElement(Document document, String string) {
        return document.createElementNS(NAMESPACE, string);
    }
}

