/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.data;

import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.DataValueVisitor;

public class FloatData
implements DataValue {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private float mValue;

    public FloatData(float f) {
        this.mValue = f;
    }

    public void accept(DataValueVisitor dataValueVisitor) {
        if (dataValueVisitor == null) {
            throw new IllegalArgumentException("visitor must not be null");
        }
        dataValueVisitor.visitFloatData(this);
    }

    public boolean isFinalBlock() {
        return false;
    }

    public float getFloat() {
        return this.mValue;
    }

    public String toString() {
        return Float.toString(this.mValue);
    }

    public int hashCode() {
        return new Float(this.mValue).hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FloatData)) {
            return false;
        }
        FloatData floatData = (FloatData)object;
        return this.mValue == floatData.mValue;
    }
}

