/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.data;

import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.DataValueVisitor;

public class DoubleData
implements DataValue {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private double mValue;

    public DoubleData(double d) {
        this.mValue = d;
    }

    public void accept(DataValueVisitor dataValueVisitor) {
        if (dataValueVisitor == null) {
            throw new IllegalArgumentException("visitor must not be null");
        }
        dataValueVisitor.visitDoubleData(this);
    }

    public boolean isFinalBlock() {
        return false;
    }

    public double getDouble() {
        return this.mValue;
    }

    public String toString() {
        return Double.toString(this.mValue);
    }

    public int hashCode() {
        return new Double(this.mValue).hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DoubleData)) {
            return false;
        }
        DoubleData doubleData = (DoubleData)object;
        return this.mValue == doubleData.mValue;
    }
}

